/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.Config;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_1091;
import net.minecraft.class_1767;
import net.minecraft.class_2960;

public class MobCaptureCardModelsConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "mob_capture_card_models.cfg";
    public static final String CONFIG_FILE_HEADER = " Mob Capture Card Models Configuration\n\n This configuration file allows you to define the models for the Mob Capture Cards.\n\n The format is as follows:\n - <entity_name> = <resource_location>\n - <entity_name>::<variant> = <resource_location>\n - <entity_name>::<color> = <resource_location>\n - <entity_name>::<variant>::<color> = <resource_location>\n\n Example:\n - minecraft:zombie = easy_mob_farm:item/mob_capture_card/minecraft/zombie\n - minecraft:zombie::blue = easy_mob_farm:item/mob_capture_card/minecraft/zombie_blue\n - minecraft:zombie::old::blue = easy_mob_farm:item/mob_capture_card/minecraft/zombie_old_blue\n\n The mods tries to load and bake the models for the Mob Capture Cards based on the configuration.\n However, if the model is not found, the default model will be used.\n\n";
    private static final StringBuilder KEY_BUILDER = new StringBuilder();
    private static final String KEY_SEPARATOR = "::";
    private static final HashMap<String, class_1091> mobCaptureCardModels = new HashMap();
    private static final String MOB_CAPTURE_CARD_PREFIX = "easy_mob_farm:item/mob_capture_card/minecraft/";
    private static final HashMap<String, String> defaultModels = new HashMap();

    public static void registerConfig() {
        MobCaptureCardModelsConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MobCaptureCardModelsConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        String propertyValue;
        File configFile = MobCaptureCardModelsConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MobCaptureCardModelsConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        for (Map.Entry<String, String> entry : defaultModels.entrySet()) {
            String propertyKey = entry.getKey();
            propertyValue = entry.getValue();
            if (properties.containsKey(propertyKey)) continue;
            properties.setProperty(propertyKey, propertyValue);
        }
        Set<String> propertyKeys = properties.stringPropertyNames();
        for (String propertyKey : propertyKeys) {
            propertyValue = MobCaptureCardModelsConfig.parseConfigValue(properties, propertyKey, "");
            if (propertyValue.isEmpty()) continue;
            mobCaptureCardModels.put(propertyKey, new class_1091(new class_2960(propertyValue.replaceFirst(":item/", ":")), "inventory"));
        }
        MobCaptureCardModelsConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static class_1091 getModelResourceLocation(String entityName) {
        return mobCaptureCardModels.get(entityName);
    }

    public static class_1091 getModelResourceLocation(String entityName, String variant, class_1767 color) {
        return mobCaptureCardModels.getOrDefault(MobCaptureCardModelsConfig.getEntityKey(entityName, variant, color), mobCaptureCardModels.get(entityName));
    }

    public static Set<String> getMobCaptureCardModels() {
        return mobCaptureCardModels.keySet();
    }

    public static String getEntityKey(String entityName, String variant, class_1767 color) {
        KEY_BUILDER.setLength(0);
        KEY_BUILDER.append(entityName.trim().toLowerCase(Locale.ROOT));
        if (color == null && (variant == null || variant.isEmpty())) {
            return KEY_BUILDER.toString();
        }
        if (variant != null && !variant.isEmpty()) {
            KEY_BUILDER.append(KEY_SEPARATOR).append(variant.trim().toLowerCase(Locale.ROOT));
        }
        if (color != null) {
            KEY_BUILDER.append(KEY_SEPARATOR).append(color.method_7792().toLowerCase(Locale.ROOT));
        }
        return KEY_BUILDER.toString();
    }

    public static Object[] extractEntityKeyData(String entityKey) {
        String[] parts = entityKey.split(KEY_SEPARATOR);
        String entityName = parts[0];
        if (entityName.isEmpty()) {
            return new Object[]{null, null, null};
        }
        String variant = null;
        class_1767 color = null;
        if (parts.length == 3) {
            variant = parts[1];
            try {
                color = class_1767.valueOf((String)parts[2].toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (parts.length == 2) {
            if (entityName.equals("minecraft:cat")) {
                variant = parts[1];
            } else {
                try {
                    color = class_1767.valueOf((String)parts[1].toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    variant = parts[1];
                }
            }
        }
        return new Object[]{entityName, variant, color};
    }

    static {
        defaultModels.put("minecraft:bee", "easy_mob_farm:item/mob_capture_card/minecraft/bee");
        defaultModels.put("minecraft:blaze", "easy_mob_farm:item/mob_capture_card/minecraft/blaze");
        defaultModels.put("minecraft:cat::all_black", "easy_mob_farm:item/mob_capture_card/minecraft/cat_all_black");
        defaultModels.put("minecraft:cat::black", "easy_mob_farm:item/mob_capture_card/minecraft/cat_black");
        defaultModels.put("minecraft:cat::british_shorthair", "easy_mob_farm:item/mob_capture_card/minecraft/cat_british_shorthair");
        defaultModels.put("minecraft:cat::calico", "easy_mob_farm:item/mob_capture_card/minecraft/cat_calico");
        defaultModels.put("minecraft:cat::jellie", "easy_mob_farm:item/mob_capture_card/minecraft/cat_jellie");
        defaultModels.put("minecraft:cat::persian", "easy_mob_farm:item/mob_capture_card/minecraft/cat_persian");
        defaultModels.put("minecraft:cat::ragdoll", "easy_mob_farm:item/mob_capture_card/minecraft/cat_ragdoll");
        defaultModels.put("minecraft:cat::red", "easy_mob_farm:item/mob_capture_card/minecraft/cat_red");
        defaultModels.put("minecraft:cat::siamese", "easy_mob_farm:item/mob_capture_card/minecraft/cat_siamese");
        defaultModels.put("minecraft:cat::tabby", "easy_mob_farm:item/mob_capture_card/minecraft/cat_tabby");
        defaultModels.put("minecraft:cat::white", "easy_mob_farm:item/mob_capture_card/minecraft/cat_white");
        defaultModels.put("minecraft:chicken", "easy_mob_farm:item/mob_capture_card/minecraft/chicken");
        defaultModels.put("minecraft:cod", "easy_mob_farm:item/mob_capture_card/minecraft/cod");
        defaultModels.put("minecraft:cow", "easy_mob_farm:item/mob_capture_card/minecraft/cow");
        defaultModels.put("minecraft:creeper", "easy_mob_farm:item/mob_capture_card/minecraft/creeper");
        defaultModels.put("minecraft:drowned", "easy_mob_farm:item/mob_capture_card/minecraft/drowned");
        defaultModels.put("minecraft:enderman", "easy_mob_farm:item/mob_capture_card/minecraft/enderman");
        defaultModels.put("minecraft:evoker", "easy_mob_farm:item/mob_capture_card/minecraft/evoker");
        defaultModels.put("minecraft:frog", "easy_mob_farm:item/mob_capture_card/minecraft/frog");
        defaultModels.put("minecraft:frog::cold", "easy_mob_farm:item/mob_capture_card/minecraft/frog_cold");
        defaultModels.put("minecraft:frog::temperate", "easy_mob_farm:item/mob_capture_card/minecraft/frog_temperate");
        defaultModels.put("minecraft:frog::warm", "easy_mob_farm:item/mob_capture_card/minecraft/frog_warm");
        defaultModels.put("minecraft:glow_squid", "easy_mob_farm:item/mob_capture_card/minecraft/glow_squid");
        defaultModels.put("minecraft:guardian", "easy_mob_farm:item/mob_capture_card/minecraft/guardian");
        defaultModels.put("minecraft:husk", "easy_mob_farm:item/mob_capture_card/minecraft/husk");
        defaultModels.put("minecraft:iron_golem", "easy_mob_farm:item/mob_capture_card/minecraft/iron_golem");
        defaultModels.put("minecraft:magma_cube", "easy_mob_farm:item/mob_capture_card/minecraft/magma_cube");
        defaultModels.put("minecraft:phantom", "easy_mob_farm:item/mob_capture_card/minecraft/phantom");
        defaultModels.put("minecraft:pig", "easy_mob_farm:item/mob_capture_card/minecraft/pig");
        defaultModels.put("minecraft:piglin", "easy_mob_farm:item/mob_capture_card/minecraft/piglin");
        defaultModels.put("minecraft:piglin_brute", "easy_mob_farm:item/mob_capture_card/minecraft/piglin_brute");
        defaultModels.put("minecraft:pillager", "easy_mob_farm:item/mob_capture_card/minecraft/pillager");
        defaultModels.put("minecraft:rabbit", "easy_mob_farm:item/mob_capture_card/minecraft/rabbit");
        defaultModels.put("minecraft:sheep", "easy_mob_farm:item/mob_capture_card/minecraft/sheep");
        defaultModels.put("minecraft:sheep::black", "easy_mob_farm:item/mob_capture_card/minecraft/sheep_black");
        defaultModels.put("minecraft:sheep::blue", "easy_mob_farm:item/mob_capture_card/minecraft/sheep_blue");
        defaultModels.put("minecraft:sheep::brown", "easy_mob_farm:item/mob_capture_card/minecraft/sheep_brown");
        defaultModels.put("minecraft:sheep::gray", "easy_mob_farm:item/mob_capture_card/minecraft/sheep_gray");
        defaultModels.put("minecraft:sheep::light_gray", "easy_mob_farm:item/mob_capture_card/minecraft/sheep_light_gray");
        defaultModels.put("minecraft:sheep::pink", "easy_mob_farm:item/mob_capture_card/minecraft/sheep_pink");
        defaultModels.put("minecraft:sheep::red", "easy_mob_farm:item/mob_capture_card/minecraft/sheep_red");
        defaultModels.put("minecraft:sheep::white", "easy_mob_farm:item/mob_capture_card/minecraft/sheep_white");
        defaultModels.put("minecraft:skeleton", "easy_mob_farm:item/mob_capture_card/minecraft/skeleton");
        defaultModels.put("minecraft:slime", "easy_mob_farm:item/mob_capture_card/minecraft/slime");
        defaultModels.put("minecraft:spider", "easy_mob_farm:item/mob_capture_card/minecraft/spider");
        defaultModels.put("minecraft:squid", "easy_mob_farm:item/mob_capture_card/minecraft/squid");
        defaultModels.put("minecraft:turtle", "easy_mob_farm:item/mob_capture_card/minecraft/turtle");
        defaultModels.put("minecraft:villager", "easy_mob_farm:item/mob_capture_card/minecraft/villager");
        defaultModels.put("minecraft:warden", "easy_mob_farm:item/mob_capture_card/minecraft/warden");
        defaultModels.put("minecraft:witch", "easy_mob_farm:item/mob_capture_card/minecraft/witch");
        defaultModels.put("minecraft:wither", "easy_mob_farm:item/mob_capture_card/minecraft/wither");
        defaultModels.put("minecraft:wither_skeleton", "easy_mob_farm:item/mob_capture_card/minecraft/wither_skeleton");
        defaultModels.put("minecraft:zombie", "easy_mob_farm:item/mob_capture_card/minecraft/zombie");
        defaultModels.put("minecraft:zombie_villager", "easy_mob_farm:item/mob_capture_card/minecraft/zombie_villager");
        defaultModels.put("minecraft:zombified_piglin", "easy_mob_farm:item/mob_capture_card/minecraft/zombified_piglin");
    }
}

