/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.Config;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1814;
import net.minecraft.class_7923;

public class MobCaptureCardRarityConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "mob_capture_card_rarity.cfg";
    public static final String CONFIG_FILE_HEADER = " Mob Capture Card Rarity Configuration\n\n This configuration file allows you to define the rarity for the Mob Capture Cards.\n\n The format is as follows:\n - <entity_name> = Rarity\n\n Example:\n - minecraft:zombie = COMMON\n\n Supported rarities are:\n  - COMMON\n  - UNCOMMON\n  - RARE\n  - EPIC\n\n";
    private static final HashMap<String, class_1814> mobCaptureCardRarity = new HashMap();
    private static final HashMap<String, class_1814> defaultRarity = new HashMap();

    public static void registerConfig() {
        MobCaptureCardRarityConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MobCaptureCardRarityConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        class_1814 propertyValue;
        File configFile = MobCaptureCardRarityConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MobCaptureCardRarityConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        for (Map.Entry<String, class_1814> entry : defaultRarity.entrySet()) {
            String propertyKey = entry.getKey();
            propertyValue = entry.getValue();
            if (properties.containsKey(propertyKey)) continue;
            properties.setProperty(propertyKey, propertyValue.name());
        }
        Set<String> propertyKeys = properties.stringPropertyNames();
        for (String propertyKey : propertyKeys) {
            propertyValue = MobCaptureCardRarityConfig.parseConfigValue(properties, propertyKey, class_1814.field_8906);
            mobCaptureCardRarity.put(propertyKey.trim().toLowerCase(Locale.ROOT), propertyValue);
        }
        MobCaptureCardRarityConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static boolean hasRarity(class_1299<?> entityType) {
        return MobCaptureCardRarityConfig.hasRarity(class_7923.field_41177.method_10221(entityType).toString());
    }

    public static boolean hasRarity(String entityName) {
        return mobCaptureCardRarity.containsKey(entityName.trim().toLowerCase(Locale.ROOT));
    }

    public static class_1814 getRarity(class_1299<?> entityType) {
        return MobCaptureCardRarityConfig.getRarity(class_7923.field_41177.method_10221(entityType).toString());
    }

    public static class_1814 getRarity(String entityName) {
        return mobCaptureCardRarity.getOrDefault(entityName.trim().toLowerCase(Locale.ROOT), class_1814.field_8906);
    }

    static {
        defaultRarity.put("minecraft:bat", class_1814.field_8906);
        defaultRarity.put("minecraft:cat", class_1814.field_8906);
        defaultRarity.put("minecraft:chicken", class_1814.field_8906);
        defaultRarity.put("minecraft:cow", class_1814.field_8906);
        defaultRarity.put("minecraft:creeper", class_1814.field_8906);
        defaultRarity.put("minecraft:drowned", class_1814.field_8906);
        defaultRarity.put("minecraft:horse", class_1814.field_8906);
        defaultRarity.put("minecraft:pig", class_1814.field_8906);
        defaultRarity.put("minecraft:pillager", class_1814.field_8906);
        defaultRarity.put("minecraft:sheep", class_1814.field_8906);
        defaultRarity.put("minecraft:skeleton", class_1814.field_8906);
        defaultRarity.put("minecraft:spider", class_1814.field_8906);
        defaultRarity.put("minecraft:squid", class_1814.field_8906);
        defaultRarity.put("minecraft:villager", class_1814.field_8906);
        defaultRarity.put("minecraft:witch", class_1814.field_8906);
        defaultRarity.put("minecraft:wolf", class_1814.field_8906);
        defaultRarity.put("minecraft:zombie", class_1814.field_8906);
        defaultRarity.put("minecraft:cave_spider", class_1814.field_8907);
        defaultRarity.put("minecraft:enderman", class_1814.field_8907);
        defaultRarity.put("minecraft:evoker", class_1814.field_8907);
        defaultRarity.put("minecraft:fox", class_1814.field_8907);
        defaultRarity.put("minecraft:husk", class_1814.field_8907);
        defaultRarity.put("minecraft:llama", class_1814.field_8907);
        defaultRarity.put("minecraft:panda", class_1814.field_8907);
        defaultRarity.put("minecraft:polar_bear", class_1814.field_8907);
        defaultRarity.put("minecraft:slime", class_1814.field_8907);
        defaultRarity.put("minecraft:stray", class_1814.field_8907);
        defaultRarity.put("minecraft:zombified_piglin", class_1814.field_8907);
        defaultRarity.put("minecraft:zombified_villager", class_1814.field_8907);
        defaultRarity.put("minecraft:blaze", class_1814.field_8903);
        defaultRarity.put("minecraft:ghast", class_1814.field_8903);
        defaultRarity.put("minecraft:guardian", class_1814.field_8903);
        defaultRarity.put("minecraft:magma_cube", class_1814.field_8903);
        defaultRarity.put("minecraft:phantom", class_1814.field_8903);
        defaultRarity.put("minecraft:ravager", class_1814.field_8903);
        defaultRarity.put("minecraft:shulker", class_1814.field_8903);
        defaultRarity.put("minecraft:strider", class_1814.field_8903);
        defaultRarity.put("minecraft:vindicator", class_1814.field_8903);
        defaultRarity.put("minecraft:elder_guardian", class_1814.field_8904);
        defaultRarity.put("minecraft:ender_dragon", class_1814.field_8904);
        defaultRarity.put("minecraft:illusioner", class_1814.field_8904);
        defaultRarity.put("minecraft:piglin_brute", class_1814.field_8904);
        defaultRarity.put("minecraft:warden", class_1814.field_8904);
        defaultRarity.put("minecraft:wither", class_1814.field_8904);
        defaultRarity.put("minecraft:wither_skeleton", class_1814.field_8904);
    }
}

