/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.mobfarm;

import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.menu.MobFarmMenu;
import net.minecraft.world.inventory.ContainerData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmContainerData
implements ContainerData {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private final MobFarmBlockEntity mobFarmEntity;

    public MobFarmContainerData(MobFarmBlockEntity mobFarmEntity) {
        this.mobFarmEntity = mobFarmEntity;
    }

    public int get(int index) {
        return switch (index) {
            case 0 -> this.mobFarmEntity.getBlockPos().getX();
            case 1 -> this.mobFarmEntity.getBlockPos().getY();
            case 2 -> this.mobFarmEntity.getBlockPos().getZ();
            case 3 -> this.mobFarmEntity.getNumberOfOutputSlots();
            case 4 -> this.mobFarmEntity.getFarmProgress();
            case 9 -> this.mobFarmEntity.getFarmProgressionSpeed();
            case 10 -> this.mobFarmEntity.getFarmProgressionSpeedBonus();
            case 5 -> this.mobFarmEntity.getFarmStatus();
            case 6 -> this.mobFarmEntity.getFarmTierLevel();
            case 7 -> this.mobFarmEntity.getFarmType().ordinal();
            case 8 -> this.mobFarmEntity.getCapturedMobExperience();
            default -> 0;
        };
    }

    public void set(int index, int value) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                log.warn("Trying to set read-only data index {} for {}", (Object)index, (Object)this);
                break;
            }
            case 3: {
                this.mobFarmEntity.setNumberOfOutputSlots(value);
                break;
            }
            case 4: {
                this.mobFarmEntity.setFarmProgress(value);
                break;
            }
            case 5: {
                this.mobFarmEntity.setFarmStatus(value);
                break;
            }
            default: {
                log.error("Unknown data index {}", (Object)index);
            }
        }
    }

    public int getCount() {
        return MobFarmMenu.CONTAINER_DATA_SIZE;
    }
}

