/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.component.DataComponents;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmData;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmBlock
extends BaseEntityBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WORKING = BooleanProperty.create((String)"working");
    public static final IntegerProperty TIER_LEVEL = IntegerProperty.create((String)"tier_level", (int)0, (int)3);
    public static final EnumProperty<MobFarmType> FARM_TYPE = EnumProperty.create((String)"farm_type", MobFarmType.class);
    public static final MapCodec<MobFarmBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MobFarmType.CODEC.fieldOf("mobFarmType").forGetter(block -> MobFarmBlock.getFarmType(block.defaultBlockState()))).apply((Applicative)instance, MobFarmBlock::new));
    protected static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    public MobFarmBlock(MobFarmType mobFarmType) {
        this(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)mobFarmType.getId()))).mapColor(MapColor.STONE).requiresCorrectToolForDrops().strength(5.0f).lightLevel(MobFarmBlock::getLightLevel).sound(SoundType.METAL).noOcclusion(), mobFarmType);
    }

    public MobFarmBlock(BlockBehaviour.Properties properties, MobFarmType mobFarmType) {
        this(properties, 0, mobFarmType);
    }

    public MobFarmBlock(BlockBehaviour.Properties properties, int tierLevel, MobFarmType mobFarmType) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WORKING, (Comparable)Boolean.FALSE)).setValue((Property)TIER_LEVEL, (Comparable)Integer.valueOf(tierLevel))).setValue(FARM_TYPE, (Comparable)((Object)mobFarmType)));
    }

    public static int getLightLevel(BlockState blockState) {
        return Boolean.TRUE.equals(blockState.getValue((Property)WORKING)) ? 15 : 8;
    }

    public static int getTierLevel(BlockState blockState) {
        return (Integer)blockState.getValue((Property)TIER_LEVEL);
    }

    public static MobFarmType getFarmType(BlockState blockState) {
        return (MobFarmType)((Object)blockState.getValue(FARM_TYPE));
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState, MobFarmType mobFarmType) {
        throw new UnsupportedOperationException("This method must be overridden by a subclass!");
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void onRemove(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof MobFarmBlockEntity) {
                MobFarmBlockEntity mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity;
                mobFarmBlockEntity.dropInventoryContents();
                level.updateNeighbourForOutputSignal(blockPos, (Block)this);
            }
            super.onRemove(state, level, blockPos, newState, isMoving);
        }
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return this.newBlockEntity(blockPos, blockState, MobFarmBlock.getFarmType(blockState));
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockState) {
        blockState.add(new Property[]{FACING, WORKING, TIER_LEVEL, FARM_TYPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof MobFarmBlockEntity) {
            MobFarmBlockEntity blockEntityInstance = (MobFarmBlockEntity)blockEntity;
            if (level instanceof ServerLevel) {
                MobFarmData mobFarmData;
                int tierLevel;
                ServerLevel serverLevel = (ServerLevel)level;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    blockEntityInstance.setOwner((Player)serverPlayer);
                }
                if ((tierLevel = (mobFarmData = (MobFarmData)itemStack.getOrDefault(DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY)).tierLevel().getTierLevel()) >= 0) {
                    BlockState newBlockState = (BlockState)blockState.setValue((Property)TIER_LEVEL, (Comparable)Integer.valueOf(tierLevel));
                    serverLevel.setBlock(blockPos, newBlockState, 3);
                    blockEntityInstance.setFarmTierLevel(tierLevel);
                    blockEntity.setChanged();
                }
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.openMenu(level, blockPos, player);
        return InteractionResult.CONSUME;
    }

    public InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof MobFarmBlockEntity)) {
            return InteractionResult.FAIL;
        }
        MobFarmBlockEntity mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity;
        if (!itemStack.isEmpty() && (mobFarmBlockEntity.takeMobCaptureItem(player, interactionHand) || mobFarmBlockEntity.takeEnhancementItem(player, interactionHand) || mobFarmBlockEntity.takeSlotUpgradeItem(player, interactionHand) || mobFarmBlockEntity.takeFilterItem(player, interactionHand))) {
            return InteractionResult.CONSUME;
        }
        if (player.isShiftKeyDown() && mobFarmBlockEntity.hasCapturedMob()) {
            mobFarmBlockEntity.giveMobCaptureItem(player, interactionHand);
            return InteractionResult.CONSUME;
        }
        this.openMenu(level, blockPos, player);
        return InteractionResult.CONSUME;
    }

    protected void openMenu(Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof MobFarmBlockEntity) {
            MobFarmBlockEntity blockEntityInstance = (MobFarmBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)blockEntityInstance);
            }
        }
    }
}

