/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.scores.PlayerTeam;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ScreenHelper {
    private ScreenHelper() {
    }

    public static void renderEntity(GuiGraphics guiGraphics, int x, int y, float yRot, float xRot, float scale, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ScreenHelper.renderEntity(guiGraphics, x, y, yRot, xRot, scale, livingEntity);
        }
    }

    public static void renderEntity(GuiGraphics guiGraphics, int x, int y, float yRot, float xRot, float scale, LivingEntity livingEntity) {
        FlyingAnimal flyingAnimal;
        boolean isDead = livingEntity.isDeadOrDying();
        Minecraft minecraft = Minecraft.getInstance();
        float rotationY = (float)Math.atan((isDead ? 25.0f : yRot) / 40.0f);
        float rotationX = (float)Math.atan((isDead ? -25.0f : xRot) / 40.0f);
        Quaternionf quaternionfZ = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionfX = new Quaternionf().rotateX(rotationX * 20.0f * ((float)Math.PI / 180));
        quaternionfZ.mul((Quaternionfc)quaternionfX);
        Component entityCustomName = livingEntity.getCustomName();
        boolean entityShouldShowName = livingEntity.shouldShowName();
        float entityXRot = livingEntity.getXRot();
        float entityYBodyRot = livingEntity.yBodyRot;
        float entityYHeadRot = livingEntity.yHeadRot;
        float entityYHeadRotO = livingEntity.yHeadRotO;
        float entityYRot = livingEntity.getYRot();
        boolean entityInvisible = livingEntity.isInvisible();
        PlayerTeam entityTeam = livingEntity.getTeam();
        livingEntity.setInvisible(false);
        livingEntity.yBodyRot = 180.0f + rotationY * 20.0f;
        livingEntity.setYRot(180.0f + rotationY * 40.0f);
        livingEntity.setXRot(-rotationX * 20.0f);
        livingEntity.yHeadRot = livingEntity.getYRot();
        livingEntity.yHeadRotO = livingEntity.getYRot();
        if (entityTeam instanceof PlayerTeam) {
            PlayerTeam playerTeam = entityTeam;
            livingEntity.level().getScoreboard().removePlayerFromTeam(livingEntity.getScoreboardName(), playerTeam);
        }
        boolean minecraftHideGui = false;
        if (minecraft != null) {
            minecraftHideGui = minecraft.options.hideGui;
            minecraft.options.hideGui = true;
        } else {
            livingEntity.setCustomName(null);
            livingEntity.setCustomNameVisible(false);
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)x, (double)y, 300.0);
        guiGraphics.pose().scale(scale, scale, -scale);
        guiGraphics.pose().mulPose(quaternionfZ);
        if (livingEntity instanceof AbstractSchoolingFish) {
            guiGraphics.pose().translate(-0.1, 0.5, 0.1);
            guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(2.0f));
            guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(15.0f));
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(-90.0f));
        } else if (livingEntity instanceof Bee) {
            guiGraphics.pose().translate(0.0, 0.5, 0.0);
        } else if (livingEntity instanceof Squid) {
            guiGraphics.pose().translate(0.0, 1.3, 0.0);
        } else if (livingEntity instanceof Phantom || livingEntity instanceof Guardian) {
            guiGraphics.pose().translate(0.0, 0.5, 0.0);
        } else if (livingEntity instanceof FlyingMob || livingEntity instanceof FlyingAnimal && (flyingAnimal = (FlyingAnimal)livingEntity).isFlying()) {
            guiGraphics.pose().translate(0.0, 1.0 * (double)scale, 0.0);
        }
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        quaternionfX.conjugate();
        entityRenderDispatcher.overrideCameraOrientation(quaternionfX);
        entityRenderDispatcher.setRenderShadow(false);
        guiGraphics.drawSpecial(bufferSource -> entityRenderDispatcher.render((Entity)livingEntity, 0.0, 0.0, 0.0, 1.0f, guiGraphics.pose(), bufferSource, 0xF000F0));
        guiGraphics.flush();
        entityRenderDispatcher.setRenderShadow(true);
        guiGraphics.pose().popPose();
        Lighting.setupFor3DItems();
        livingEntity.setInvisible(entityInvisible);
        livingEntity.yBodyRot = entityYBodyRot;
        livingEntity.setYRot(entityYRot);
        livingEntity.setXRot(entityXRot);
        livingEntity.yHeadRot = entityYHeadRot;
        livingEntity.yHeadRotO = entityYHeadRotO;
        if (entityTeam instanceof PlayerTeam) {
            PlayerTeam playerTeam = entityTeam;
            livingEntity.level().getScoreboard().addPlayerToTeam(livingEntity.getScoreboardName(), playerTeam);
        }
        if (minecraft != null) {
            minecraft.options.hideGui = minecraftHideGui;
        } else {
            livingEntity.setCustomName(entityCustomName);
            livingEntity.setCustomNameVisible(entityShouldShowName);
        }
    }
}

