/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.entity;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.config.MobCaptureCardConfig;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FishingEvents {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Random RANDOM = new Random();

    private FishingEvents() {
    }

    public static void handleItemFishedEvent(ServerPlayer serverPlayer, List<ItemStack> lootList) {
        if (!MobCaptureCardConfig.dropMobCaptureCardOnFishing) {
            return;
        }
        Item fishLoot = null;
        for (ItemStack itemStack : lootList) {
            if (itemStack.isEmpty() || !itemStack.is(ItemTags.FISHES)) continue;
            fishLoot = itemStack.getItem();
            break;
        }
        if (fishLoot == null) {
            return;
        }
        ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey(fishLoot);
        Optional entityType = BuiltInRegistries.ENTITY_TYPE.get(resourceLocation);
        if (entityType.isEmpty()) {
            return;
        }
        String entityName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)((Holder.Reference)entityType.get()).value())).toString();
        if (MobCaptureCardConfig.mobCaptureCardFishingDropDenyList.contains(entityName) || !MobCaptureCardConfig.mobCaptureCardFishingDropAllowList.isEmpty() && !MobCaptureCardConfig.mobCaptureCardFishingDropAllowList.contains(entityName)) {
            log.debug("[Skip] Mob capture card fishing drop for {}.", (Object)entityName);
            return;
        }
        if (MobCaptureCardConfig.mobCaptureCardFishingDropChance > 0.0f && RANDOM.nextFloat() > MobCaptureCardConfig.mobCaptureCardFishingDropChance) {
            return;
        }
        ItemStack itemStack = MobCaptureManager.getMobCaptureCardItem((EntityType)((Holder.Reference)entityType.get()).value(), serverPlayer.level());
        if (itemStack != null) {
            log.debug("Dropped mob capture card {} for {}.", (Object)itemStack, (Object)entityType);
            serverPlayer.spawnAtLocation(serverPlayer.serverLevel(), itemStack, 0.5f);
        } else {
            log.error("Failed to drop mob capture card for {}.", (Object)entityType);
        }
    }
}

