/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.entity;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.config.MobCaptureCardConfig;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LivingEntityEvents {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Random RANDOM = new Random();

    private LivingEntityEvents() {
    }

    public static void handleLivingEntityDeathEvent(LivingEntity livingEntity, DamageSource damageSource) {
        Level level;
        if (!MobCaptureCardConfig.dropMobCaptureCardOnKill) {
            return;
        }
        if (MobCaptureCardConfig.requirePlayerKill && (damageSource.getEntity() == null || !(damageSource.getEntity() instanceof Player))) {
            return;
        }
        String entityName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)livingEntity.getType()).toString();
        if (MobCaptureCardConfig.mobCaptureCardKillDropDenyList.contains(entityName) || !MobCaptureCardConfig.mobCaptureCardKillDropAllowList.isEmpty() && !MobCaptureCardConfig.mobCaptureCardKillDropAllowList.contains(entityName)) {
            log.debug("[Skip] Mob capture card kill drop for {}.", (Object)entityName);
            return;
        }
        if (MobCaptureCardConfig.mobCaptureCardKillDropChance > 0.0f && RANDOM.nextFloat() > MobCaptureCardConfig.mobCaptureCardKillDropChance) {
            return;
        }
        ItemStack itemStack = MobCaptureManager.getMobCaptureCardItem(livingEntity);
        if (itemStack != null && (level = livingEntity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            log.debug("Dropped mob capture card {} for {}.", (Object)itemStack, (Object)livingEntity);
            livingEntity.spawnAtLocation(serverLevel, itemStack, 0.5f);
        } else {
            log.error("Failed to drop mob capture card for {}.", (Object)livingEntity);
        }
    }
}

