/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.tabs;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.config.MobCaptureCardModelsConfig;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobColor;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomMobCaptureCards {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    private CustomMobCaptureCards() {
    }

    public static Set<ItemStack> getCustomMobCaptureCards(ItemLike mobCaptureCardItem) {
        if (!(mobCaptureCardItem instanceof MobCaptureCardItem)) {
            return Collections.emptySet();
        }
        LinkedHashSet<ItemStack> result = new LinkedHashSet<ItemStack>();
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Common Card", EntityType.ARMOR_STAND, Rarity.COMMON)));
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Uncommon Card", EntityType.ARMOR_STAND, Rarity.UNCOMMON)));
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Rare Card", EntityType.ARMOR_STAND, Rarity.RARE)));
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Epic Card", EntityType.ARMOR_STAND, Rarity.EPIC)));
        MobCaptureCardModelsConfig.getMobCaptureCardModels().forEach(modelKey -> {
            Object[] modelKeyData = MobCaptureCardModelsConfig.extractEntityKeyData(modelKey);
            if (modelKeyData[0] == null) {
                return;
            }
            String entityName = (String)modelKeyData[0];
            if (entityName.isEmpty()) {
                log.error("Empty entity type for mob capture card at key {}!", modelKey);
                return;
            }
            Optional entityType = BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)entityName));
            if (entityType.isEmpty()) {
                if (entityName.startsWith("minecraft:")) {
                    log.error("Unknown entity type {} for mob capture card!", (Object)entityName);
                } else {
                    log.warn("Unknown entity type {} for mob capture card!", (Object)entityName);
                }
                return;
            }
            ItemStack itemStack = MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, entityType.map(Holder.Reference::value).orElse(null), (String)modelKeyData[1], (MobColor)((Object)((Object)modelKeyData[2])));
            if (itemStack != null) {
                result.add(itemStack);
            }
        });
        return result;
    }
}

