/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.capture;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobColor;
import de.markusbordihn.easymobfarm.data.capture.MobEntityData;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCaptureManager {
    public static final String COLOR_TAG = "Color";
    public static final String VARIANT_TAG = "variant";
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[MobCaptureManager]";

    private MobCaptureManager() {
    }

    public static ItemStack getMobCaptureCardItem(EntityType<?> entityType, Level level) {
        if (entityType == null || level == null) {
            return null;
        }
        Entity entity = entityType.create(level);
        if (entity == null) {
            log.error("{} Unable to create entity {}!", (Object)LOG_PREFIX, entityType);
            return null;
        }
        if (!(entity instanceof LivingEntity)) {
            log.error("{} Entity {} is not a living entity!", (Object)LOG_PREFIX, entityType);
            entity.discard();
            return null;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ItemStack itemStack = MobCaptureManager.getMobCaptureCardItem(livingEntity);
        log.debug("{} Captured mob {} with data:{}.", (Object)LOG_PREFIX, entityType, (Object)itemStack);
        entity.discard();
        return itemStack;
    }

    public static ItemStack getMobCaptureCardItem(LivingEntity livingEntity) {
        if (livingEntity == null || livingEntity instanceof Player || livingEntity.level().isClientSide) {
            return null;
        }
        MobCaptureCardItem mobCaptureCardItem = MobCaptureCardItem.getMobCaptureCardItem();
        if (mobCaptureCardItem == null) {
            log.error("{} Unable to find mob capture card item!", (Object)LOG_PREFIX);
            return null;
        }
        MobCaptureData mobCaptureData = new MobCaptureData(livingEntity);
        if (mobCaptureData.entityType() == null || mobCaptureData.data() == null) {
            log.debug("{} Unable to get mob capture data from living entity {}.", (Object)LOG_PREFIX, (Object)livingEntity);
            return null;
        }
        mobCaptureData = mobCaptureData.withData(MobEntityData.removeSafeToRemoveMobCaptureCardTags(mobCaptureData.data()));
        ItemStack itemStack = new ItemStack((ItemLike)mobCaptureCardItem);
        MobCaptureManager.writeMobCaptureData(itemStack, mobCaptureData);
        log.debug("{} Captured mob {} with data:{}", (Object)LOG_PREFIX, mobCaptureData.entityType(), (Object)mobCaptureData.data());
        return itemStack;
    }

    public static boolean releaseMob(MobCaptureData mobCaptureData, BlockPos blockPos, ServerLevel serverLevel) {
        BlockPos safeSpawnBlockPos;
        if (mobCaptureData == null || mobCaptureData.entityType() == null) {
            return false;
        }
        EntityType<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            return false;
        }
        Entity entity = entityType.create((Level)serverLevel);
        if (entity == null) {
            log.error("{} Unable to create entity {}!", (Object)LOG_PREFIX, entityType);
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.readAdditionalSaveData(mobCaptureData.data());
        }
        if ((safeSpawnBlockPos = MobCaptureManager.getSafeSpawnPos((Level)serverLevel, blockPos)) == null) {
            log.warn("{} Unable to release mob {} with data:{} at block position {}.", (Object)LOG_PREFIX, entityType, (Object)mobCaptureData.data(), (Object)blockPos);
            return false;
        }
        entity.moveTo((double)safeSpawnBlockPos.getX() + 0.5, (double)safeSpawnBlockPos.getY() + 1.0, (double)safeSpawnBlockPos.getZ() + 0.5, 0.0f, 0.0f);
        serverLevel.addFreshEntity(entity);
        log.debug("{} Released mob {} with data:{} at block position {}.", (Object)LOG_PREFIX, entityType, (Object)mobCaptureData.data(), (Object)safeSpawnBlockPos);
        return true;
    }

    public static ItemStack createMobCaptureCard(ItemLike itemLike, EntityType<?> entityType) {
        if (itemLike == null || entityType == null) {
            return null;
        }
        return MobCaptureManager.createMobCaptureCard(itemLike, new MobCaptureData(entityType).withFoil(false));
    }

    public static ItemStack createMobCaptureCard(ItemLike itemLike, MobCaptureData mobCaptureData) {
        if (itemLike == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(itemLike);
        MobCaptureManager.writeMobCaptureData(itemStack, mobCaptureData);
        return itemStack;
    }

    public static ItemStack createMobCaptureCard(ItemLike itemLike, EntityType<?> entityType, String variant, MobColor mobColor) {
        if (itemLike == null || entityType == null) {
            return null;
        }
        MobCaptureData mobCaptureData = new MobCaptureData(entityType).withFoil(false);
        CompoundTag compoundTag = new CompoundTag();
        if (variant != null && !variant.isEmpty()) {
            mobCaptureData = mobCaptureData.withVariant(variant);
            if (entityType == EntityType.CAT || entityType == EntityType.FROG) {
                compoundTag.putString(VARIANT_TAG, variant);
            }
        }
        if (mobColor != null && mobColor != MobColor.NONE) {
            mobCaptureData = mobCaptureData.withColor(mobColor);
            compoundTag.putInt(COLOR_TAG, mobColor.getDyeColor().getId());
        }
        return MobCaptureManager.createMobCaptureCard(itemLike, mobCaptureData.withData(compoundTag));
    }

    public static void writeMobCaptureData(ItemStack itemStack, MobCaptureData mobCaptureData) {
        if (itemStack == null || itemStack.isEmpty() || mobCaptureData == null) {
            return;
        }
        itemStack.set(de.markusbordihn.easymobfarm.component.DataComponents.MOB_CAPTURE_DATA, (Object)mobCaptureData);
    }

    public static boolean hasMobCaptureData(ItemStack itemStack) {
        return itemStack != null && !itemStack.isEmpty() && itemStack.has(de.markusbordihn.easymobfarm.component.DataComponents.MOB_CAPTURE_DATA) && !((MobCaptureData)itemStack.getOrDefault(de.markusbordihn.easymobfarm.component.DataComponents.MOB_CAPTURE_DATA, (Object)MobCaptureData.EMPTY)).isEmpty();
    }

    public static MobCaptureData getMobCaptureData(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return null;
        }
        if (itemStack.has(de.markusbordihn.easymobfarm.component.DataComponents.MOB_CAPTURE_DATA)) {
            return (MobCaptureData)itemStack.get(de.markusbordihn.easymobfarm.component.DataComponents.MOB_CAPTURE_DATA);
        }
        return new MobCaptureData(itemStack, ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).getUnsafe());
    }

    public static boolean isSafeSpawnPos(Level level, BlockPos blockPos) {
        BlockState surfaceState = level.getBlockState(blockPos.below());
        BlockState groundState = level.getBlockState(blockPos.below(2));
        VoxelShape surfaceShape = surfaceState.getCollisionShape((BlockGetter)level, blockPos.below());
        VoxelShape groundShape = groundState.getCollisionShape((BlockGetter)level, blockPos.below(2));
        double surfaceHeight = surfaceShape.isEmpty() ? 0.0 : surfaceShape.bounds().maxY;
        double groundHeight = groundShape.isEmpty() ? 0.0 : groundShape.bounds().maxY;
        return (!surfaceState.isAir() || !(surfaceHeight < 0.05)) && !groundState.isAir() && groundHeight >= 0.5;
    }

    public static BlockPos getSafeSpawnPos(Level level, BlockPos blockPos) {
        if (MobCaptureManager.isSafeSpawnPos(level, blockPos)) {
            return blockPos;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos nearbyPos;
                if (dx == 0 && dz == 0 || !MobCaptureManager.isSafeSpawnPos(level, nearbyPos = blockPos.offset(dx, 0, dz))) continue;
                return nearbyPos;
            }
        }
        return null;
    }
}

