/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class MobNameData {
    public static final String NAME_TAG = "Name";
    public static final String TYPE_TAG = "Type";
    public static final String ID_TAG = "id";

    private MobNameData() {
    }

    public static String getName(EntityType<?> entityType) {
        return entityType.getDescriptionId();
    }

    public static String getName(LivingEntity livingEntity) {
        return livingEntity.getType().getDescriptionId();
    }

    public static String getName(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return "";
        }
        String name = compoundTag.getString(NAME_TAG);
        if (compoundTag.contains(NAME_TAG) && name.startsWith("entity.") && name.equals(name.toLowerCase(Locale.ROOT))) {
            return name;
        }
        String entityTypeName = compoundTag.getString(TYPE_TAG);
        if (!compoundTag.contains(TYPE_TAG)) {
            entityTypeName = compoundTag.getString(ID_TAG);
        }
        if (!entityTypeName.contains(":") || !entityTypeName.equals(entityTypeName.toLowerCase(Locale.ROOT))) {
            return "";
        }
        EntityType entityType = EntityType.byString((String)entityTypeName).orElse(null);
        return entityType != null ? entityType.getDescriptionId() : "";
    }
}

