/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.gametest;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.MobFarmTemplateBlock;
import de.markusbordihn.easymobfarm.component.DataComponents;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmData;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmTierLevel;
import de.markusbordihn.easymobfarm.gametest.GameTestHelpers;
import de.markusbordihn.easymobfarm.item.MobFarmBlockItem;
import de.markusbordihn.easymobfarm.item.MobFarmTemplateItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class MobFarmBlockItemTestHelper {
    private MobFarmBlockItemTestHelper() {
    }

    public static void testMobFarmBlockItem(GameTestHelper helper, Item item, Block block) {
        MobFarmBlockItemTestHelper.useMobFarmBlockItem(helper, new ItemStack((ItemLike)item), block, new BlockPos(0, 1, 0));
    }

    public static void useMobFarmBlockItem(GameTestHelper helper, Item item, MobFarmTierLevel tierLevel, Block block) {
        BlockPos blockPos = new BlockPos(0, 1, 0);
        ItemStack itemStack = new ItemStack((ItemLike)item);
        MobFarmData mobFarmData = MobFarmData.EMPTY.withTierLevel(tierLevel);
        itemStack.set(DataComponents.MOB_FARM_DATA, (Object)mobFarmData);
        MobFarmBlockItemTestHelper.useMobFarmBlockItem(helper, itemStack, block, blockPos);
        BlockState blockState = helper.getBlockState(blockPos);
        GameTestHelpers.assertTrue(helper, "Expected tier level " + String.valueOf((Object)tierLevel) + " but found " + MobFarmBlock.getTierLevel(blockState), MobFarmBlock.getTierLevel(blockState) == tierLevel.getTierLevel());
    }

    public static void useMobFarmBlockItem(GameTestHelper helper, ItemStack itemStack, Block block, BlockPos blockPos) {
        if (itemStack.getItem() instanceof MobFarmBlockItem && block instanceof MobFarmBlock) {
            MobFarmBlock mobFarmBlock = (MobFarmBlock)block;
            MobFarmBlockItemTestHelper.useAndTestMobFarmBlockItem(helper, itemStack, (Block)mobFarmBlock, blockPos);
        } else if (itemStack.getItem() instanceof MobFarmTemplateItem && block instanceof MobFarmTemplateBlock) {
            MobFarmTemplateBlock mobFarmTemplateBlock = (MobFarmTemplateBlock)block;
            MobFarmBlockItemTestHelper.useAndTestMobFarmBlockItem(helper, itemStack, mobFarmTemplateBlock, blockPos);
        } else {
            helper.fail("Item " + String.valueOf(itemStack.getItem()) + " is not a MobFarmBlockItem or Block " + String.valueOf(block) + " is not a MobFarmBlock");
        }
    }

    public static void useAndTestMobFarmBlockItem(GameTestHelper helper, ItemStack mobFarmBlockItemStack, Block mobFarmBlock, BlockPos blockPos) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setItemInHand(player.getUsedItemHand(), mobFarmBlockItemStack);
        UseOnContext useOnContext = new UseOnContext(player, player.getUsedItemHand(), new BlockHitResult(helper.absoluteVec(new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ())), Direction.UP, helper.absolutePos(blockPos), false));
        mobFarmBlockItemStack.useOn(useOnContext);
        helper.assertBlockPresent(mobFarmBlock, blockPos);
    }
}

