/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.Config;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_1299;

public class RequiresKilledByPlayerConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "requires_killed_by_player.cfg";
    public static final String CONFIG_FILE_HEADER = " Requires Killed By Player Configuration\n\n This configuration file lists the known entities which requires \"killed_by_player\" for looting.\n\n  The format is as follows:\n  - <entity_name> : true\n\n";
    public static final Set<class_1299<?>> requiresKilledByPlayerEntities = new HashSet();
    private static final Set<String> knownRequiresKilledByPlayerEntities = new HashSet<String>(List.of("minecraft:blaze", "minecraft:cave_spider", "minecraft:drowned", "minecraft:elder_guardian", "minecraft:evoker", "minecraft:guardian", "minecraft:husk", "minecraft:phantom", "minecraft:rabbit", "minecraft:spider", "minecraft:stray", "minecraft:vindicator", "minecraft:wither_skeleton", "minecraft:zombie", "minecraft:zombie_villager", "minecraft:zombified_piglin"));

    public static void registerConfig() {
        RequiresKilledByPlayerConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        RequiresKilledByPlayerConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = RequiresKilledByPlayerConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = RequiresKilledByPlayerConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        for (String entityType : knownRequiresKilledByPlayerEntities) {
            RequiresKilledByPlayerConfig.parseConfigValue(properties, entityType, true);
        }
        for (String entityTypeName : properties.stringPropertyNames()) {
            if (entityTypeName == null || !entityTypeName.contains(":")) {
                log.error("Remove invalid entity type name {} from {}.", (Object)entityTypeName, (Object)CONFIG_FILE_NAME);
                properties.remove(entityTypeName);
                continue;
            }
            Optional entityType = class_1299.method_5898((String)entityTypeName);
            if (!entityType.isPresent() || requiresKilledByPlayerEntities.contains(entityType.get())) continue;
            if (RequiresKilledByPlayerConfig.parseConfigValue(properties, entityTypeName, false)) {
                requiresKilledByPlayerEntities.add((class_1299)entityType.get());
                continue;
            }
            requiresKilledByPlayerEntities.remove(entityType.get());
        }
        RequiresKilledByPlayerConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static boolean requiresKilledByPlayer(class_1299<?> entityType) {
        return requiresKilledByPlayerEntities.contains(entityType);
    }
}

