#version 150

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>

uniform sampler2D Sampler0;

in float sphericalVertexDistance;
in float cylindricalVertexDistance;
in vec2 texCoord0;
in vec4 vertexColor;

in vec4 baseColor;

out vec4 fragColor;

void main() {

    vec4 texColor = texture(Sampler0, texCoord0);

    if (texColor.a < 1.0 && baseColor.r > 0.99 && baseColor.g > 0.99 && baseColor.b > 0.99)
    {
        discard;
    }

    vec4 color = texColor * vertexColor;

    if (color.a < 0.1) {
        discard;
    }

    fragColor = apply_fog(color, sphericalVertexDistance, cylindricalVertexDistance, FogEnvironmentalStart, FogEnvironmentalEnd, FogRenderDistanceStart, FogRenderDistanceEnd, FogColor);
}
