#version 150

const vec3 white_in = vec3(1.00, 1.00, 1.00);
const vec3 orange_in = vec3(1.00, 0.66, 0.00);
const vec3 magenta_in = vec3(1.00, 0.33, 1.00);
const vec3 light_blue_in = vec3(0.33, 1.00, 1.00);
const vec3 yellow_in = vec3(1.00, 1.00, 0.33);
const vec3 lime_in = vec3(0.33, 1.00, 0.33);
const vec3 pink_in = vec3(0.66, 0.00, 0.00);
const vec3 gray_in = vec3(0.33, 0.33, 0.33);
const vec3 light_gray_in = vec3(0.66, 0.66, 0.66);
const vec3 cyan_in = vec3(0.00, 0.66, 0.66);
const vec3 purple_in = vec3(0.66, 0.00, 0.66);
const vec3 blue_in = vec3(0.00, 0.00, 0.66);
const vec3 brown_in = vec3(0.33, 0.33, 1.00);
const vec3 green_in = vec3(0.00, 0.66, 0.00);
const vec3 red_in = vec3(1.00, 0.33, 0.33);
const vec3 black_in = vec3(0.00, 0.00, 0.00);

const vec3 white_out = vec3(249 / 255.0, 255 / 255.0, 254 / 255.0);
const vec3 orange_out = vec3(249 / 255.0, 128 / 255.0, 29 / 255.0);
const vec3 magenta_out = vec3(199 / 255.0, 78 / 255.0, 189 / 255.0);
const vec3 light_blue_out = vec3(58 / 255.0, 179 / 255.0, 218 / 255.0);
const vec3 yellow_out = vec3(254 / 255.0, 216 / 255.0, 61 / 255.0);
const vec3 lime_out = vec3(128 / 255.0, 199 / 255.0, 31 / 255.0);
const vec3 pink_out = vec3(243 / 255.0, 139 / 255.0, 170 / 255.0);
const vec3 gray_out = vec3(71 / 255.0, 79 / 255.0, 82 / 255.0);
const vec3 light_gray_out = vec3(157 / 255.0, 157 / 255.0, 151 / 255.0);
const vec3 cyan_out = vec3(22 / 255.0, 156 / 255.0, 156 / 255.0);
const vec3 purple_out = vec3(137 / 255.0, 50 / 255.0, 184 / 255.0);
const vec3 blue_out = vec3(60 / 255.0, 68 / 255.0, 170 / 255.0);
const vec3 brown_out = vec3(131 / 255.0, 84 / 255.0, 50 / 255.0);
const vec3 green_out = vec3(94 / 255.0, 124 / 255.0, 22 / 255.0);
const vec3 red_out = vec3(176 / 255.0, 46 / 255.0, 38 / 255.0);
const vec3 black_out = vec3(29 / 255.0, 29 / 255.0, 33 / 255.0);

bool approx(float a, float b, float tol) { return abs(a - b) < tol; }

bool matches(vec3 a, vec3 b) {
    return approx(a.r, b.r, 0.01) && approx(a.g, b.g, 0.01) &&
           approx(a.b, b.b, 0.01);
}

vec3 adjust_color(vec3 in_color) {
    if (matches(in_color, white_in)) return white_out;
    if (matches(in_color, orange_in)) return orange_out;
    if (matches(in_color, magenta_in )) return magenta_out;
    if (matches(in_color, light_blue_in)) return light_blue_out;
    if (matches(in_color, yellow_in)) return yellow_out;
    if (matches(in_color, lime_in)) return lime_out;
    if (matches(in_color, pink_in)) return pink_out;
    if (matches(in_color, gray_in)) return gray_out;
    if (matches(in_color, light_gray_in)) return light_gray_out;
    if (matches(in_color, cyan_in)) return cyan_out;
    if (matches(in_color, purple_in)) return purple_out;
    if (matches(in_color, blue_in)) return blue_out;
    if (matches(in_color, brown_in)) return brown_out;
    if (matches(in_color, green_in)) return green_out;
    if (matches(in_color, red_in)) return red_out;
    if (matches(in_color, black_in)) return black_out;
    return in_color;
}