# Tag entities for easy tracking
tag @s add child
tag @n[type=#mutagenic:breedable,nbt={Age:6000},limit=2] add parent
tag @n[type=#mutagenic:breedable,nbt={Age:5999},limit=2] add parent

tag @e[tag=parent,sort=random,limit=1] add parent_a
tag @n[tag=parent,tag=!parent_a] add parent_b

# Check parent food type
execute as @n[tag=parent_a] if predicate mutagenic:fed_mythical as @n[tag=parent_b] if predicate mutagenic:fed_mythical run data modify entity @n[tag=child] data.parents.fed_mythical set value 1b
execute as @n[tag=parent_a] if predicate mutagenic:fed_luminous as @n[tag=parent_b] if predicate mutagenic:fed_luminous run data modify entity @n[tag=child] data.parents.fed_luminous set value 1b
execute as @n[tag=parent_a] if predicate mutagenic:fed_chromatic as @n[tag=parent_b] if predicate mutagenic:fed_chromatic run data modify entity @n[tag=child] data.parents.fed_chromatic set value 1b

# Store our parent colors and food for macro use later
data modify entity @s data.parents.color_a set from entity @n[tag=parent_a] data.color
data modify entity @s data.parents.color_b set from entity @n[tag=parent_b] data.color

# By default, use dye mixing rules
data modify entity @s data.parents.mix_mode set value "default"

# If we used luminous food, and a random parent is luminous, use additive mixing rules
execute if entity @s[nbt={data:{parents:{fed_luminous:1b}}}] if entity @n[tag=parent_a,tag=mutagenic_luminous] run data modify entity @s data.parents.mix_mode set value "glowing"

# Get our target color based on the food our parents were given
function mutagenic:breeding/determine_color

# Get our final variant based on our color and the tier of food our parents were given
function mutagenic:breeding/determine_variant

# Get a truncated string version of our variant, then initialize any equipment, tags, etc. our mob needs
data modify entity @s data.variant set string entity @s variant 10
function mutagenic:variant/initialize_m with entity @s data

# Clear effects from parents
execute as @n[tag=parent,limit=2] run function mutagenic:breeding/clear_effects

tag @n[tag=parent_a] remove parent_a
tag @n[tag=parent_b] remove parent_b
tag @n[tag=parent,limit=2] remove parent
tag @s remove child
