/*
 * Decompiled with CFR 0.152.
 */
package nieboczek.moreladders.datagen;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import nieboczek.moreladders.block.MLBlocks;

public final class BlockStateGenerator
extends BlockStateProvider {
    BlockStateGenerator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "moreladders", exFileHelper);
    }

    private void ladder(Block block) {
        String path = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(path, this.modLoc("block/base_ladder"))).texture("texture", this.blockTexture(block))).texture("particle", this.blockTexture(block));
        this.horizontalBlock(block, (ModelFile)model);
        ((ItemModelBuilder)this.itemModels().withExistingParent(path, this.mcLoc("item/generated"))).texture("layer0", this.blockTexture(block));
    }

    private void deriveFromUnwaxed(Block waxed, Block unwaxed) {
        String waxedPath = BuiltInRegistries.BLOCK.getKey((Object)waxed).getPath();
        ModelFile.ExistingModelFile unwaxedModel = this.models().getExistingFile(BuiltInRegistries.BLOCK.getKey((Object)unwaxed));
        this.horizontalBlock(waxed, (ModelFile)unwaxedModel);
        ((ItemModelBuilder)this.itemModels().withExistingParent(waxedPath, this.mcLoc("item/generated"))).texture("layer0", this.blockTexture(unwaxed));
    }

    protected void registerStatesAndModels() {
        this.ladder(MLBlocks.SPRUCE_LADDER);
        this.ladder(MLBlocks.BIRCH_LADDER);
        this.ladder(MLBlocks.DARK_OAK_LADDER);
        this.ladder(MLBlocks.JUNGLE_LADDER);
        this.ladder(MLBlocks.WARPED_LADDER);
        this.ladder(MLBlocks.CRIMSON_LADDER);
        this.ladder(MLBlocks.IRON_LADDER);
        this.ladder(MLBlocks.ACACIA_LADDER);
        this.ladder(MLBlocks.CHAIN_LADDER);
        this.ladder(MLBlocks.CHERRY_LADDER);
        this.ladder(MLBlocks.BAMBOO_LADDER);
        this.ladder(MLBlocks.MANGROVE_LADDER);
        this.ladder(MLBlocks.GOLD_LADDER);
        this.ladder(MLBlocks.PALE_OAK_LADDER);
        this.ladder(MLBlocks.COPPER_LADDER);
        this.ladder(MLBlocks.EXPOSED_COPPER_LADDER);
        this.ladder(MLBlocks.WEATHERED_COPPER_LADDER);
        this.ladder(MLBlocks.OXIDIZED_COPPER_LADDER);
        this.deriveFromUnwaxed(MLBlocks.WAXED_COPPER_LADDER, MLBlocks.COPPER_LADDER);
        this.deriveFromUnwaxed(MLBlocks.WAXED_EXPOSED_COPPER_LADDER, MLBlocks.EXPOSED_COPPER_LADDER);
        this.deriveFromUnwaxed(MLBlocks.WAXED_WEATHERED_COPPER_LADDER, MLBlocks.WEATHERED_COPPER_LADDER);
        this.deriveFromUnwaxed(MLBlocks.WAXED_OXIDIZED_COPPER_LADDER, MLBlocks.OXIDIZED_COPPER_LADDER);
    }
}

