/*
 * Decompiled with CFR 0.152.
 */
package nieboczek.moreladders.datagen;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import nieboczek.moreladders.datagen.BlockLootGenerator;
import nieboczek.moreladders.datagen.BlockStateGenerator;
import nieboczek.moreladders.datagen.BlockTagsGenerator;
import nieboczek.moreladders.datagen.DataMapGenerator;
import nieboczek.moreladders.datagen.RecipeGenerator;

@EventBusSubscriber(modid="moreladders")
public final class DataGenerators {
    @SubscribeEvent
    private static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper exFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGenerator(output, exFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DataMapGenerator(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new BlockTagsGenerator(output, lookupProvider, exFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLootGenerator::new, LootContextParamSets.BLOCK)), lookupProvider));
    }
}

