/*
 * Decompiled with CFR 0.152.
 */
package nieboczek.moreladders.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import nieboczek.moreladders.block.MLBlocks;

public final class RecipeGenerator
extends RecipeProvider {
    RecipeGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    private static String getCriterionName(ItemLike item) {
        return "has_" + BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
    }

    private static void ladder(RecipeOutput output, ItemLike inner, ItemLike outer, ItemLike result) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)4).define(Character.valueOf('|'), outer).define(Character.valueOf('#'), inner).pattern("| |").pattern("|#|").pattern("| |").unlockedBy(RecipeGenerator.getCriterionName(inner), RecipeGenerator.has((ItemLike)inner)).save(output);
    }

    private static void wax(RecipeOutput output, ItemLike input, ItemLike result) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).requires(input).requires((ItemLike)Items.HONEYCOMB).unlockedBy(RecipeGenerator.getCriterionName(input), RecipeGenerator.has((ItemLike)input)).save(output);
    }

    protected void buildRecipes(RecipeOutput output) {
        RecipeGenerator.ladder(output, (ItemLike)Items.SPRUCE_PLANKS, (ItemLike)Items.STICK, (ItemLike)MLBlocks.SPRUCE_LADDER);
        RecipeGenerator.ladder(output, (ItemLike)Items.BIRCH_PLANKS, (ItemLike)Items.STICK, (ItemLike)MLBlocks.BIRCH_LADDER);
        RecipeGenerator.ladder(output, (ItemLike)Items.DARK_OAK_PLANKS, (ItemLike)Items.STICK, (ItemLike)MLBlocks.DARK_OAK_LADDER);
        RecipeGenerator.ladder(output, (ItemLike)Items.JUNGLE_PLANKS, (ItemLike)Items.STICK, (ItemLike)MLBlocks.JUNGLE_LADDER);
        RecipeGenerator.ladder(output, (ItemLike)Items.WARPED_PLANKS, (ItemLike)Items.STICK, (ItemLike)MLBlocks.WARPED_LADDER);
        RecipeGenerator.ladder(output, (ItemLike)Items.CRIMSON_PLANKS, (ItemLike)Items.STICK, (ItemLike)MLBlocks.CRIMSON_LADDER);
        RecipeGenerator.ladder(output, (ItemLike)Items.IRON_INGOT, (ItemLike)Items.IRON_NUGGET, (ItemLike)MLBlocks.IRON_LADDER);
        RecipeGenerator.ladder(output, (ItemLike)Items.ACACIA_PLANKS, (ItemLike)Items.STICK, (ItemLike)MLBlocks.ACACIA_LADDER);
        RecipeGenerator.ladder(output, (ItemLike)Items.CHAIN, (ItemLike)Items.IRON_NUGGET, (ItemLike)MLBlocks.CHAIN_LADDER);
        RecipeGenerator.ladder(output, (ItemLike)Items.CHERRY_PLANKS, (ItemLike)Items.STICK, (ItemLike)MLBlocks.CHERRY_LADDER);
        RecipeGenerator.ladder(output, (ItemLike)Items.BAMBOO_PLANKS, (ItemLike)Items.BAMBOO, (ItemLike)MLBlocks.BAMBOO_LADDER);
        RecipeGenerator.ladder(output, (ItemLike)Items.MANGROVE_PLANKS, (ItemLike)Items.STICK, (ItemLike)MLBlocks.MANGROVE_LADDER);
        RecipeGenerator.ladder(output, (ItemLike)Items.GOLD_INGOT, (ItemLike)Items.GOLD_NUGGET, (ItemLike)MLBlocks.GOLD_LADDER);
        RecipeGenerator.ladder(output, (ItemLike)Items.COPPER_INGOT, (ItemLike)Items.COPPER_INGOT, (ItemLike)MLBlocks.COPPER_LADDER);
        RecipeGenerator.wax(output, (ItemLike)MLBlocks.COPPER_LADDER, (ItemLike)MLBlocks.WAXED_COPPER_LADDER);
        RecipeGenerator.wax(output, (ItemLike)MLBlocks.EXPOSED_COPPER_LADDER, (ItemLike)MLBlocks.WAXED_EXPOSED_COPPER_LADDER);
        RecipeGenerator.wax(output, (ItemLike)MLBlocks.WEATHERED_COPPER_LADDER, (ItemLike)MLBlocks.WAXED_WEATHERED_COPPER_LADDER);
        RecipeGenerator.wax(output, (ItemLike)MLBlocks.WAXED_OXIDIZED_COPPER_LADDER, (ItemLike)MLBlocks.WAXED_OXIDIZED_COPPER_LADDER);
    }
}

