package archives.tater.doorjam;

import archives.tater.doorjam.data.DoorJamBlockTags;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_8177;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoorJam implements ModInitializer {

    public static final String MOD_ID = "doorjam";

    public static class_2960 id(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }

    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static final class_2960 MOST_OXIDIZED_ID = id("most_oxidized");

    public static boolean mayJam(class_2680 state) {
        return state.method_26164(DoorJamBlockTags.SLIGHT_JAMMING_CHANCE) ||
                state.method_26164(DoorJamBlockTags.HALF_JAMMING_CHANCE) ||
                state.method_26164(DoorJamBlockTags.MOST_JAMMING_CHANCE);
    }

    public static boolean alwaysJam(class_2680 state) {
        return state.method_26164(DoorJamBlockTags.FULL_JAMMING_CHANCE);
    }

    public static void playLockedSound(class_1937 world, @Nullable class_1657 source, class_2338 pos, class_8177 type) {
        world.method_8396(source, pos, type.comp_1291(), class_3419.field_15245, 1.0F, world.method_8409().method_43057() * 0.1F + 0.5F);
    }

    /**
     * Both doors and trapdoors use this code.
     * @return if the door jammed
     */
    public static boolean tryOpenDoor(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_8177 blockSetType) {
        if (DoorJam.alwaysJam(state)) {
            DoorJam.playLockedSound(world, player, pos, blockSetType);
        } else if (DoorJam.mayJam(state)) {
            if (!world.method_8608())
                if (DoorJam.isJammed(state, world.method_8409())) {
                    DoorJam.playLockedSound(world, null, pos, blockSetType);
                } else {
                    return true;
                }
        } else return true;

        return false;
    }

    public static boolean isJammed(class_2680 state, class_5819 random){
        return state.method_26164(DoorJamBlockTags.FULL_JAMMING_CHANCE) ||
                (state.method_26164(DoorJamBlockTags.MOST_JAMMING_CHANCE) && random.method_43057() < 0.75f) ||
                (state.method_26164(DoorJamBlockTags.HALF_JAMMING_CHANCE) && random.method_43057() < 0.5f) ||
                (state.method_26164(DoorJamBlockTags.SLIGHT_JAMMING_CHANCE) && random.method_43057() < 0.25f);
    }

    @Override
    public void onInitialize() {
        DoorJamBlockTags.init();
        //noinspection OptionalGetWithoutIsPresent
        ResourceManagerHelper.registerBuiltinResourcePack(
                MOST_OXIDIZED_ID,
                FabricLoader.getInstance().getModContainer(MOD_ID).get(),
                class_2561.method_43470("Most Oxidized"),
                ResourcePackActivationType.NORMAL
        );
    }
}
