package archives.tater.doorjam.data;

import com.google.common.collect.ImmutableMap;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_7225.class_7874;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class DoorJamBlockTagProvider extends FabricTagProvider.BlockTagProvider {

    public DoorJamBlockTagProvider(FabricDataOutput output, CompletableFuture<class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    protected static final Map<String, String> COMPAT_LIST = ImmutableMap.of(
            "shutter", "shutter",
            "metalfences", "fence_gate"
    );

    @Override
    protected void method_10514(class_7874 wrapperLookup) {
        valueLookupBuilder(DoorJamBlockTags.SLIGHT_JAMMING_CHANCE)
                .method_71554(class_2246.field_47041)
                .method_71554(class_2246.field_47049);

        valueLookupBuilder(DoorJamBlockTags.HALF_JAMMING_CHANCE)
                .method_71554(class_2246.field_47043)
                .method_71554(class_2246.field_47051);
        valueLookupBuilder(DoorJamBlockTags.FULL_JAMMING_CHANCE)
                .method_71554(class_2246.field_47042)
                .method_71554(class_2246.field_47050);

        COMPAT_LIST.forEach((modid, itemName) -> {
            method_27169(DoorJamBlockTags.SLIGHT_JAMMING_CHANCE).method_34891(class_2960.method_60655(modid, "exposed_copper_" + itemName));
            method_27169(DoorJamBlockTags.HALF_JAMMING_CHANCE).method_34891(class_2960.method_60655(modid, "weathered_copper_" + itemName));
            method_27169(DoorJamBlockTags.FULL_JAMMING_CHANCE).method_34891(class_2960.method_60655(modid, "oxidized_copper_" + itemName));
        });
    }
}
