/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import ru.magistu.siegemachines.init.IngredientTypes;

public record CountIngredientNeoForge(Ingredient base, int count) implements ICustomIngredient
{
    public static final MapCodec<CountIngredientNeoForge> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("base").forGetter(CountIngredientNeoForge::base), (App)ExtraCodecs.POSITIVE_INT.fieldOf("count").forGetter(CountIngredientNeoForge::count)).apply((Applicative)instance, CountIngredientNeoForge::new));

    public boolean test(ItemStack stack) {
        return this.base.test(stack) && stack.getCount() >= this.count;
    }

    public Stream<ItemStack> getItems() {
        List<ItemStack> items = Arrays.stream(this.base.getItems()).toList();
        for (ItemStack stack : items) {
            stack.setCount(this.count);
        }
        return items.stream();
    }

    public boolean isSimple() {
        return this.base.isSimple();
    }

    public IngredientType<?> getType() {
        return (IngredientType)IngredientTypes.COUNT_INGREDIENT_TYPE.get();
    }
}

