/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ru.magistu.siegemachines.api.enitity.Useable;
import ru.magistu.siegemachines.client.ModSoundTypes;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.machine.MachineGeoEntity;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.projectile.MachineBasedExplosionDamageCalculator;
import ru.magistu.siegemachines.entity.projectile.MissileExplosion;
import ru.magistu.siegemachines.network.ModNetwork;
import ru.magistu.siegemachines.network.S2CPacketMachineUse;
import ru.magistu.siegemachines.util.BaseAnimations;
import ru.magistu.siegemachines.util.CartesianGeometry;
import ru.magistu.siegemachines.util.HitUtil;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BatteringRam
extends Machine
implements MachineGeoEntity {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int hittingticks = 0;
    private int wheelssoundticks = 10;
    public double lastwheelpitch;
    protected Entity lastUsedEntity;
    public State state = State.RELOADING;
    private double wheelspitch = 0.0;

    public BatteringRam(EntityType<? extends Mob> entitytype, Level level) {
        super(entitytype, level, MachineType.BATTERING_RAM);
    }

    @Override
    public RawAnimation getUsingRawAnimation() {
        return BaseAnimations.HITTING_ANIM;
    }

    @Override
    public RawAnimation getReloadingAnimation() {
        return BaseAnimations.RELOADING_ANIM;
    }

    @Override
    public int getDelayTime() {
        return (Integer)this.type.specs.delaytime.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.level().isClientSide() && !this.isVehicle()) {
            player.startRiding((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void travel(Vec3 velocity) {
        if (this.isAlive()) {
            if (this.isVehicle()) {
                LivingEntity livingentity = this.getControllingPassenger();
                float f1 = livingentity.zza;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.setSpeed(0.04f);
                velocity = new Vec3(0.0, velocity.y, (double)f1);
            }
            super.travel(velocity);
        }
    }

    @Override
    public void tick() {
        LivingEntity passenger;
        this.lastwheelpitch = this.wheelspitch;
        this.wheelspitch += this.getWheelsSpeed();
        if (this.hittingticks != 0 && --this.hittingticks <= 0) {
            this.useRelease();
            this.hittingticks = 0;
        }
        if (this.level().isClientSide() && this.hasControllingPassenger() && this.getWheelsSpeed() > 0.0081 && this.wheelssoundticks-- <= 0 && Minecraft.getInstance().player == (passenger = this.getControllingPassenger())) {
            Vec3 pos = this.position();
            this.level().playLocalSound(pos.x, pos.y, pos.z, (SoundEvent)ModSoundTypes.RAM_WHEELS.get(), this.getSoundSource(), 1.5f, 0.85f + this.level().random.nextFloat() * 0.3f, false);
            this.wheelssoundticks = 20;
        }
        super.tick();
    }

    public double getLerpedWheelPitch(float partialTick) {
        return Mth.lerp((double)partialTick, (double)this.lastwheelpitch, (double)this.wheelspitch);
    }

    @Override
    public void use(LivingEntity entity) {
        if (this.deploymentticks > 0 && entity instanceof Player) {
            Player player = (Player)entity;
            player.sendSystemMessage((Component)Component.translatable((String)"siegemachines.wait", (Object[])new Object[]{Float.valueOf((float)this.deploymentticks / 20.0f)}).withStyle(ChatFormatting.RED));
            return;
        }
        if (!this.level().isClientSide()) {
            ModNetwork.sendPacketToAllInArea((ServerLevel)this.level(), new S2CPacketMachineUse(this.getId()), this.blockPosition(), 16384);
        }
        this.lastUsedEntity = entity;
        if (this.getDelayTicks() <= 0 && this.getUseTicks() <= 0 && this.hittingticks <= 0) {
            this.usesoundplayer.run();
            this.state = State.HITTING;
            this.setUseTicks(this.type.usetime);
            this.hittingticks = this.type.usereleasetime;
        }
    }

    public void ramHit(BlockPos blockpos) {
        if (!this.level().isClientSide()) {
            int x = blockpos.getX();
            int y = blockpos.getY();
            int z = blockpos.getZ();
            BatteringRam source = this.lastUsedEntity == null ? this : this.lastUsedEntity;
            MissileExplosion explosion = new MissileExplosion(this.level(), (Entity)source, this.level().damageSources().explosion((Entity)this, (Entity)source), this.getExplosionDamageCalculator(), x, y, z, 2.0f, false, Explosion.BlockInteraction.DESTROY, null, null, null);
            explosion.explode();
            explosion.finalizeExplosion(false);
        }
    }

    private ExplosionDamageCalculator getExplosionDamageCalculator() {
        return new MachineBasedExplosionDamageCalculator(this);
    }

    @Nullable
    private LivingEntity getIndirectSourceEntityInternal() {
        return this.getControllingPassenger() != null ? this.getControllingPassenger() : this;
    }

    @Override
    public void useRelease() {
        if (this.deploymentticks > 0) {
            LivingEntity livingEntity = this.getControllingPassenger();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.sendSystemMessage((Component)Component.translatable((String)"siegemachines.wait", (Object[])new Object[]{Float.valueOf((float)this.deploymentticks / 20.0f)}).withStyle(ChatFormatting.RED));
            }
            return;
        }
        this.usereleasesoundplayer.run();
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)66);
            BlockPos blockpos = BlockPos.containing((Position)this.getHitPos());
            this.ramHit(blockpos);
        }
    }

    private Vec3 getHitPos() {
        Vec3 delta;
        double pitch = (double)this.getTurretPitch() * Math.PI / 180.0;
        double yaw = (double)(this.getViewYRot(0.5f) + this.getTurretYaw()) * Math.PI / 180.0;
        Vec3 pos = this.position().add(CartesianGeometry.applyRotations(this.type.turretpivot, 0.0, yaw));
        HitResult hit = HitUtil.getHitResult(pos, (Entity)this, e -> e.getVehicle() != this, delta = CartesianGeometry.applyRotations(this.type.turretvector, pitch, yaw), this.level(), 0.0f, ClipContext.Block.COLLIDER);
        if (hit.getType() != HitResult.Type.MISS) {
            return hit.getLocation();
        }
        return pos.add(delta);
    }

    public double getWheelsSpeed() {
        if (this.onGround()) {
            return this.getViewVector(5.0f).multiply(1.0, 0.0, 1.0).dot(this.getDeltaMovement());
        }
        return 0.0;
    }

    public void push(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
    }

    @Override
    public Useable.UsageType getUsage() {
        return Useable.UsageType.RAM;
    }

    public static enum State {
        HITTING,
        RELOADING;

    }
}

