/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ru.magistu.siegemachines.client.ModSoundTypes;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.machine.ShootingMachine;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Cannon
extends ShootingMachine
implements GeoEntity {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public double wheelspitch = 0.0;
    public double lastwheelpitch;
    private int wheelssoundticks = 10;

    public Cannon(EntityType<? extends Mob> entitytype, Level level, MachineType type) {
        super(entitytype, level, type);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem().equals(Items.FLINT_AND_STEEL)) {
            if (this.getUseTicks() <= 0 && this.shootingticks <= 0) {
                stack.hurtAndBreak(1, (LivingEntity)player, Cannon.getSlotForHand((InteractionHand)hand));
                this.startShooting((LivingEntity)player);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.getItem().equals(Items.GUNPOWDER)) {
            if (!this.inventory.containsItem(Items.GUNPOWDER) && this.inventory.canAddItem(stack)) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                this.inventory.addItem(stack);
            }
            return InteractionResult.SUCCESS;
        }
        if (super.mobInteract(player, hand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (!this.level().isClientSide() && !this.isVehicle()) {
            player.startRiding((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void useRelease() {
        LivingEntity passenger;
        if (this.inventory.containsItem(Items.GUNPOWDER)) {
            super.useRelease();
        } else if (!this.level().isClientSide() && (passenger = this.getControllingPassenger()) instanceof Player) {
            passenger.sendSystemMessage((Component)Component.translatable((String)"siegemachines.no_gunpowder").withStyle(ChatFormatting.RED));
        }
    }

    public void travel(Vec3 velocity) {
        if (this.isAlive()) {
            if (this.getDelayTicks() <= 0 && this.isVehicle()) {
                LivingEntity livingentity = this.getControllingPassenger();
                float f0 = livingentity.xxa * 0.2f;
                float f1 = livingentity.zza;
                if (f1 <= 0.0f) {
                    f1 *= 0.5f;
                }
                this.setSpeed(0.04f);
                velocity = new Vec3((double)f0, velocity.y, (double)f1);
            }
            super.travel(velocity);
        }
    }

    @Override
    public void tick() {
        LivingEntity passenger;
        this.lastwheelpitch = this.wheelspitch;
        this.wheelspitch += this.getWheelsSpeed();
        if (this.level().isClientSide() && this.hasControllingPassenger() && this.getWheelsSpeed() > 0.0081 && this.wheelssoundticks-- <= 0 && Minecraft.getInstance().player == (passenger = this.getControllingPassenger())) {
            Vec3 pos = this.position();
            this.level().playLocalSound(pos.x, pos.y, pos.z, (SoundEvent)ModSoundTypes.CANNON_WHEELS.get(), this.getSoundSource(), 1.5f, 0.85f + this.level().random.nextFloat() * 0.3f, false);
            this.wheelssoundticks = 20;
        }
        if (!this.level().isClientSide() && this.onGround()) {
            this.setDeltaMovement(this.getWheelsDeltaMovement());
        }
        super.tick();
    }

    public double getLerpedWheelPitch(float partialTick) {
        return Mth.lerp((double)partialTick, (double)this.lastwheelpitch, (double)this.wheelspitch);
    }

    @Override
    public void startShooting(LivingEntity entity) {
        if (this.getDelayTicks() <= 0 && this.getUseTicks() <= 0 && this.shootingticks <= 0) {
            this.usesoundplayer.run();
            this.setUseTicks(this.type.usetime);
            this.shootingticks = this.type.usereleasetime;
        }
    }

    @Override
    public void shoot() {
        if (!this.level().isClientSide()) {
            super.shoot();
            this.setDeltaMovement(this.getDeltaMovement().subtract(this.getShotView().scale(0.25)));
            this.hasImpulse = true;
            this.inventory.removeItemType(Items.GUNPOWDER, 1);
        } else {
            this.blowParticles((ParticleOptions)ParticleTypes.FLAME, 0.035, 25);
            this.blowParticles((ParticleOptions)ParticleTypes.CLOUD, 0.2, 60);
        }
    }

    public double getWheelsSpeed() {
        if (this.onGround()) {
            return this.getViewVector(0.5f).multiply(1.0, 0.0, 1.0).dot(this.getDeltaMovement());
        }
        return 0.0;
    }

    public Vec3 getWheelsDeltaMovement() {
        if (this.onGround()) {
            Vec3 view = this.getViewVector(1.0f);
            Vec3 movement = this.getDeltaMovement();
            double d0 = movement.x * view.x + movement.z * view.z;
            double d1 = d0 * view.x;
            double d2 = 0.0;
            double d3 = d0 * view.z;
            return new Vec3(d1, d2, d3);
        }
        return Vec3.ZERO;
    }
}

