/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import ru.magistu.siegemachines.entity.ModEntityTypes;
import ru.magistu.siegemachines.entity.machine.Seat;
import ru.magistu.siegemachines.entity.machine.SiegeLadder;

public class LadderSeat
extends Seat {
    public final float climbspeed = 0.02f;
    private float highness = 0.0f;
    public final SiegeLadder parent;

    public LadderSeat(SiegeLadder parent) {
        super((EntityType)ModEntityTypes.SEAT.get(), parent.level());
        this.parent = parent;
    }

    public float getHighness() {
        return this.highness;
    }

    public void setHighness(float highness) {
        this.highness = highness;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        InteractionResult result = super.interact(player, hand);
        if (result.consumesAction()) {
            return result;
        }
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (this.isVehicle()) {
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide) {
            return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected void removePassenger(Entity entity) {
        this.highness = 0.0f;
        super.removePassenger(entity);
    }

    public float climb() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            if (livingentity.zza < -this.climbspeed && this.highness >= this.climbspeed) {
                return this.highness - this.climbspeed;
            }
            if (livingentity.zza > this.climbspeed && this.highness <= 1.0f - this.climbspeed) {
                return this.highness + this.climbspeed;
            }
        }
        return this.highness;
    }
}

