/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ru.magistu.siegemachines.ModTags;
import ru.magistu.siegemachines.api.enitity.Useable;
import ru.magistu.siegemachines.config.SpecsConfig;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.util.CartesianGeometry;
import ru.magistu.siegemachines.util.HitUtil;

public abstract class Machine
extends Mob
implements MenuProvider,
Useable {
    public MachineInventory inventory;
    public final MachineType type;
    protected float turretpitchprev = -25.0f;
    protected float turretpitchdest = -25.0f;
    protected float turretyawprev = this.getTurretYaw();
    protected float turretyawdest = this.getTurretYaw();
    protected float yawdest = this.getYRot();
    private boolean stationary;
    public static final EntityDataSerializer<List<ItemStack>> ITEM_STACKS_SERIALIZER = new EntityDataSerializer<List<ItemStack>>(){

        @NotNull
        public StreamCodec<? super RegistryFriendlyByteBuf, List<ItemStack>> codec() {
            return ItemStack.OPTIONAL_LIST_STREAM_CODEC;
        }

        @NotNull
        public List<ItemStack> copy(@NotNull List<ItemStack> itemstacks) {
            return new ArrayList<ItemStack>(itemstacks);
        }
    };
    private static final EntityDataAccessor<Float> DATA_TURRET_PITCH = SynchedEntityData.defineId(Machine.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_TURRET_YAW = SynchedEntityData.defineId(Machine.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_USE_TICKS = SynchedEntityData.defineId(Machine.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_DELAY_TICKS = SynchedEntityData.defineId(Machine.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> PREVENT_PICKUP_TICKS = SynchedEntityData.defineId(Machine.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<List<ItemStack>> DATA_INVENTORY_ITEMS = SynchedEntityData.defineId(Machine.class, ITEM_STACKS_SERIALIZER);
    protected int deploymentticks = 0;
    protected Runnable reloadsoundplayer;
    protected Runnable usesoundplayer;
    protected Runnable usereleasesoundplayer;
    protected static final int USE_RELEASE = 66;

    protected Machine(EntityType<? extends Mob> entitytype, Level level, MachineType type) {
        super(entitytype, level);
        this.type = type;
        this.setDelayTicks((Integer)type.specs.delaytime.get());
        this.inventory = new MachineInventory(this.type.containerrows);
        this.applyAttributeSpecs();
        this.setHealth(((Integer)type.specs.durability.get()).intValue());
        this.setTurretRotations(-type.turretinitpitch, type.turretinityaw);
        this.turretpitchprev = -type.turretinitpitch;
        this.turretyawprev = type.turretinityaw;
        this.setTurretRotationsDest(-type.turretinitpitch, type.turretinityaw);
        this.reloadsoundplayer = this.type.reloadsoundduration > 0 && this.type.reloadvolume > 0.0f && this.type.reloadsound != null ? this::playReloadSound : () -> {};
        this.usesoundplayer = this.type.usevolume > 0.0f && this.type.usesound != null ? this::playUseSound : () -> {};
        this.usereleasesoundplayer = this.type.usereleasevolume > 0.0f && this.type.usereleasesound != null ? this::playUseReleaseSound : () -> {};
    }

    public void applyAttributeSpecs() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)((Integer)this.type.specs.durability.get()).intValue());
        double knockbackresistance = (Double)this.type.specs.knockbackresistance.get();
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(knockbackresistance);
        this.stationary = knockbackresistance > 0.949;
    }

    public void setDeploymentTicks(int value) {
        this.deploymentticks = value;
    }

    public static AttributeSupplier.Builder setEntityAttributes(MachineType type) {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (double)((Integer)type.specs.durability.getDefault()).intValue()).add(Attributes.KNOCKBACK_RESISTANCE, ((Double)type.specs.knockbackresistance.getDefault()).doubleValue()).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.FOLLOW_RANGE, 0.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TURRET_PITCH, (Object)Float.valueOf(-25.0f));
        builder.define(DATA_TURRET_YAW, (Object)Float.valueOf(0.0f));
        builder.define(DATA_USE_TICKS, (Object)0);
        builder.define(DATA_DELAY_TICKS, (Object)0);
        builder.define(PREVENT_PICKUP_TICKS, (Object)0);
        builder.define(DATA_INVENTORY_ITEMS, new ArrayList());
    }

    public boolean isInvulnerableTo(DamageSource damagesource) {
        return damagesource.is(ModTags.DamageTypes.MACHINE_IMMUNE_TO) || super.isInvulnerableTo(damagesource);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (this.level().isClientSide) {
            return false;
        }
        if (this.isDeadOrDying()) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_FIRE) && this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (source.is(DamageTypes.PLAYER_ATTACK) && this.canDropAsItem()) {
                if (this.getPreventPickupTicks() > 0) {
                    player.sendSystemMessage((Component)Component.translatable((String)"siegemachines.wait", (Object[])new Object[]{Float.valueOf((float)this.getPreventPickupTicks() / 20.0f)}).withStyle(ChatFormatting.RED));
                } else {
                    this.spawnAtLocation(this.getMachineItemWithData());
                    this.dropEquipment();
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
                return false;
            }
        }
        this.setPreventPickupTicks((Integer)SpecsConfig.PREVENT_PICKUP_COOLDOWN.get());
        return super.hurt(source, this.adjustDamage(source, amount));
    }

    protected boolean canDropAsItem() {
        return this.getPassengers().isEmpty();
    }

    public float adjustDamage(DamageSource damagesource, float f) {
        if (damagesource.is(DamageTypeTags.IS_FIRE)) {
            f *= ((Double)SpecsConfig.FIRE_DAMAGE_MULTIPLIER.get()).floatValue();
        }
        if (damagesource.is(DamageTypeTags.IS_EXPLOSION)) {
            f *= ((Double)SpecsConfig.EXPLOSION_DAMAGE_MULTIPLIER.get()).floatValue();
        }
        if (damagesource.is(DamageTypes.ARROW)) {
            f *= ((Double)SpecsConfig.ARROW_DAMAGE_MULTIPLIER.get()).floatValue();
        }
        return f;
    }

    public Item getMachineItem() {
        return this.type.machineitem.get();
    }

    public void tick() {
        int delayticks;
        int useticks = this.getUseTicks();
        if (useticks > 0) {
            this.setUseTicks(--useticks);
            if (useticks <= 0) {
                this.setUseTicks(0);
                this.setDelayTicks((Integer)this.type.specs.delaytime.get());
            }
        }
        if (this.isStationary() && !this.level().isClientSide()) {
            this.stop();
        }
        if ((delayticks = this.getDelayTicks()) > 0 && this.hasControllingPassenger()) {
            if (delayticks % this.type.reloadsoundduration == 0) {
                this.reloadsoundplayer.run();
            }
            this.setDelayTicks(--delayticks);
        }
        if (this.deploymentticks > 0) {
            --this.deploymentticks;
        }
        if (this.getPreventPickupTicks() > 0) {
            this.setPreventPickupTicks(this.getPreventPickupTicks() - 1);
        }
        super.tick();
    }

    public void stop() {
        Vec3 delta = this.getDeltaMovement();
        double y = Math.min(delta.y, 0.0);
        Vec3 adjusted = new Vec3(0.0, y, 0.0);
        this.setDeltaMovement(adjusted);
        this.setSpeed(0.0f);
        if (adjusted.lengthSqr() < 1.0E-6) {
            this.hasImpulse = false;
        }
    }

    private void playReloadSound() {
        Vec3 pos = this.position();
        this.level().playLocalSound(pos.x, pos.y, pos.z, this.type.reloadsound.get(), this.getSoundSource(), this.type.reloadvolume, 1.0f, false);
    }

    private void playUseSound() {
        Vec3 pos = this.position();
        this.level().playLocalSound(pos.x, pos.y, pos.z, this.type.usesound.get(), this.getSoundSource(), this.type.usevolume, 1.0f, false);
    }

    private void playUseReleaseSound() {
        Vec3 pos = this.position();
        this.level().playLocalSound(pos.x, pos.y, pos.z, this.type.usereleasesound.get(), this.getSoundSource(), this.type.usereleasevolume, 1.0f, false);
    }

    public float getBlockExplosionResistance(Explosion explosion, BlockGetter level, BlockPos pos, BlockState blockState, FluidState fluidState, float resistance) {
        if (resistance < 4.3f) {
            return 3.0f;
        }
        return resistance * 0.7f;
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource p_184601_1_) {
        return null;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return null;
    }

    public boolean removeWhenFarAway(double p_213397_1_) {
        return false;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity livingentity;
        Entity entity = this.getFirstPassenger();
        return entity instanceof LivingEntity ? (livingentity = (LivingEntity)entity) : super.getControllingPassenger();
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        ListTag listnbt = new ListTag();
        for (ItemStack itemstack : this.inventory.getItems()) {
            CompoundTag compound = !itemstack.isEmpty() ? ItemStack.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)itemstack).resultOrPartial(error -> System.err.println("Failed to save ItemStack: " + error)).orElse(new CompoundTag()) : new CompoundTag();
            listnbt.add((Object)compound);
        }
        nbt.put("Items", (Tag)listnbt);
        nbt.putInt("DelayTicks", this.getDelayTicks());
        nbt.putInt("UseTicks", this.getUseTicks());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("Items", 9)) {
            ListTag listnbt = nbt.getList("Items", 10);
            for (int i = 0; i < this.inventory.getItems().size(); ++i) {
                this.inventory.getItems().set(i, ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)listnbt.getCompound(i)));
            }
        }
        if (nbt.contains("DelayTicks", 3)) {
            this.setDelayTicks(nbt.getInt("DelayTicks"));
        }
        if (nbt.contains("UseTicks", 3)) {
            this.setUseTicks(nbt.getInt("UseTicks"));
        }
    }

    public ItemStack getMachineItemWithData() {
        ItemStack stack = new ItemStack((ItemLike)this.getMachineItem());
        CompoundTag nbt = new CompoundTag();
        this.saveWithoutId(nbt);
        nbt.remove("Pos");
        nbt.remove("Motion");
        nbt.remove("FallDistance");
        nbt.remove("Fire");
        nbt.remove("Air");
        nbt.remove("OnGround");
        nbt.remove("Invulnerable");
        nbt.remove("PortalCooldown");
        nbt.remove("UUID");
        nbt.remove("Passengers");
        nbt.remove("DelayTicks");
        nbt.remove("UseTicks");
        nbt.remove("Items");
        String id = this.getEncodeId();
        if (id != null) {
            nbt.putString("id", id);
        }
        stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbt));
        return stack;
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
        Arrays.stream(this.type.wreckage.get()).forEach(arg_0 -> ((Machine)this).spawnAtLocation(arg_0));
    }

    protected void dropEquipment() {
        super.dropEquipment();
        this.inventory.getItems().forEach(arg_0 -> ((Machine)this).spawnAtLocation(arg_0));
        this.inventory.clearContent();
    }

    @Override
    public float getGlobalTurretYaw() {
        return Mth.lerp((float)0.5f, (float)this.yRotO, (float)this.getYRot()) + this.getTurretYaw();
    }

    public float getYaw() {
        return this.getYRot();
    }

    public void setYaw(float yaw) {
        this.setYRot(yaw);
        this.yRotO = this.getYRot();
        this.yHeadRot = this.yBodyRot = this.getYRot();
    }

    public float getYawDest() {
        return this.yawdest;
    }

    @Override
    public void setYawDest(float yaw) {
        this.yawdest = yaw;
    }

    public float getTurretPitch(float f) {
        return Mth.lerp((float)f, (float)this.turretpitchprev, (float)((Float)this.entityData.get(DATA_TURRET_PITCH)).floatValue());
    }

    public float getTurretYaw(float f) {
        return Mth.lerp((float)f, (float)this.turretyawprev, (float)((Float)this.entityData.get(DATA_TURRET_YAW)).floatValue());
    }

    @Override
    public float getTurretPitch() {
        return this.getTurretPitch(0.5f);
    }

    @Override
    public float getTurretYaw() {
        return this.getTurretYaw(0.5f);
    }

    public int getUseTicks() {
        return (Integer)this.entityData.get(DATA_USE_TICKS);
    }

    public void setUseTicks(int ticks) {
        this.entityData.set(DATA_USE_TICKS, (Object)ticks);
    }

    public int getDelayTicks() {
        return (Integer)this.entityData.get(DATA_DELAY_TICKS);
    }

    public void setDelayTicks(int ticks) {
        this.entityData.set(DATA_DELAY_TICKS, (Object)ticks);
    }

    public int getPreventPickupTicks() {
        return (Integer)this.entityData.get(PREVENT_PICKUP_TICKS);
    }

    public void setPreventPickupTicks(int ticks) {
        this.entityData.set(PREVENT_PICKUP_TICKS, (Object)ticks);
    }

    public void setTurretRotations(float pitch, float yaw) {
        this.turretpitchprev = this.getTurretPitch();
        this.turretyawprev = this.getTurretYaw();
        this.setTurretPitch(pitch);
        this.setTurretYaw(yaw);
    }

    protected void setTurretPitch(float pitch) {
        this.entityData.set(DATA_TURRET_PITCH, (Object)Float.valueOf(pitch));
    }

    protected void setTurretYaw(float yaw) {
        this.entityData.set(DATA_TURRET_YAW, (Object)Float.valueOf(yaw));
    }

    public float getTurretPitchDest() {
        return this.turretpitchdest;
    }

    public float getTurretYawDest() {
        return this.turretyawdest;
    }

    @Override
    public void setTurretRotationsDest(float pitch, float yaw) {
        this.turretpitchdest = pitch;
        this.turretyawdest = yaw;
    }

    public void updateYaw() {
        float newyaw = this.turn(this.getYaw(), this.getYawDest(), this.type.rotationspeed);
        if (this.getYaw() != newyaw) {
            this.setYaw(newyaw);
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive() && this.isVehicle() && this.getUseTicks() <= 0 && this.getDelayTicks() <= 0) {
            LivingEntity livingentity = this.getControllingPassenger();
            this.setTurretRotationsDest(livingentity.getXRot(), livingentity.getYRot() - this.getYaw());
            this.setYawDest(livingentity.getYRot());
            this.updateYaw();
            this.updateTurretRotations();
        }
    }

    public void updateTurretRotations() {
        float newpitch;
        float newyaw = this.turn(this.getTurretYaw(), this.getTurretYawDest(), this.type.turretspeed, this.type.turretminyaw, this.type.turretmaxyaw);
        boolean shouldrotate = this.checkYaw(newyaw, this.getTurretYaw(), this.type.turretspeed);
        float f = newpitch = shouldrotate ? this.turn(this.getTurretPitch(), this.getTurretPitchDest(), this.type.turretspeed, this.type.turretminpitch, this.type.turretmaxpitch) : this.getTurretPitch();
        if (this.getTurretPitch() != newpitch || this.getTurretYaw() != newyaw) {
            this.setTurretRotations(newpitch, newyaw);
        }
    }

    public boolean checkYaw(float yaw, float currentYaw, float speed) {
        return !this.type.yawfirst || Math.abs(yaw - currentYaw) <= speed / 2.0f || yaw <= this.type.turretminyaw || yaw >= this.type.turretmaxyaw;
    }

    public float turn(float rotation, float rotationDest, float speed) {
        return this.turn(rotation, rotationDest, speed, -180.0f, 180.0f);
    }

    public float turn(float rotation, float rotationDest, float speed, float minRotation, float maxRotation) {
        boolean hasLimit = maxRotation - minRotation < 360.0f;
        float deltaRotation = rotationDest - rotation;
        float newRotation = (deltaRotation = Mth.wrapDegrees((float)deltaRotation)) > speed / 2.0f ? rotation + speed : (deltaRotation < -speed / 2.0f ? rotation - speed : rotation + deltaRotation / 2.0f);
        if (hasLimit) {
            if (newRotation > -minRotation) {
                newRotation = -minRotation;
            }
            if (newRotation < -maxRotation) {
                newRotation = -maxRotation;
            }
        }
        return newRotation;
    }

    public void handleEntityEvent(byte id) {
        if (id == 66) {
            this.useRelease();
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Override
    public abstract void use(LivingEntity var1);

    public abstract void useRelease();

    public ChestMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new ChestMenu(MenuType.GENERIC_9x1, id, inv, (Container)this.inventory, 1);
    }

    public void openInventoryGui() {
        LivingEntity passenger = this.getControllingPassenger();
        if (passenger instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)passenger;
            this.stopRiding();
            serverPlayer.openMenu((MenuProvider)this);
        }
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity entity) {
        double yaw;
        Vec3 delta;
        Vec3 origin = this.position();
        HitResult hit = HitUtil.getBlockHitResult(origin, delta = CartesianGeometry.applyRotations(this.type.passengerpos, 0.0, yaw = (double)this.getGlobalTurretYaw() * Math.PI / 180.0), this.level(), ClipContext.Block.COLLIDER);
        if (hit.getType() == HitResult.Type.MISS) {
            return origin.add(delta);
        }
        return hit.getLocation();
    }

    public void positionRider(@NotNull Entity entity, @NotNull Entity.MoveFunction moveFunction) {
        Entity.MoveFunction setPos = Entity::setPos;
        if (this.hasPassenger(entity)) {
            double yaw = (double)this.getGlobalTurretYaw() * Math.PI / 180.0;
            Vec3 pos = this.position().add(CartesianGeometry.applyRotations(this.type.passengerpos, 0.0, yaw));
            setPos.accept(entity, pos.x, pos.y, pos.z);
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean isStationary() {
        return this.stationary;
    }

    public int getDelayTime() {
        return (Integer)this.type.specs.delaytime.get();
    }

    public AABB getBoundingBoxForCulling() {
        AABB box = this.getBoundingBox();
        return box.inflate(box.getXsize(), box.getYsize(), box.getZsize());
    }

    public double getExplosionDamageMultiplier() {
        return (Double)this.type.specs.explosiondamagemultiplier.get();
    }

    public class MachineInventory
    implements Container,
    StackedContentsCompatible,
    Nameable {
        private final int size;

        public MachineInventory(int rows) {
            this.size = 9 * rows;
            this.setItems(IntStream.range(0, this.size).boxed().map(i -> ItemStack.EMPTY).collect(Collectors.collectingAndThen(Collectors.toList(), ArrayList::new)));
        }

        public int getContainerSize() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.getItems().isEmpty();
        }

        public void setItems(List<ItemStack> itemstacks) {
            Machine.this.entityData.set(DATA_INVENTORY_ITEMS, itemstacks);
        }

        @NotNull
        public List<ItemStack> getItems() {
            return (List)Machine.this.entityData.get(DATA_INVENTORY_ITEMS);
        }

        public void setChanged() {
            Machine.this.entityData.set(DATA_INVENTORY_ITEMS, this.getItems(), true);
        }

        @NotNull
        public ItemStack getItem(int i) {
            return this.getItems().get(i);
        }

        @NotNull
        public ItemStack removeItem(int i, int count) {
            ItemStack itemstack = ContainerHelper.removeItem(this.getItems(), (int)i, (int)count);
            if (!itemstack.isEmpty()) {
                this.setChanged();
            }
            return itemstack;
        }

        @NotNull
        public ItemStack removeItemNoUpdate(int i) {
            return ContainerHelper.removeItem(this.getItems(), (int)i, (int)1);
        }

        public void setItem(int i, @NotNull ItemStack stack) {
            this.getItems().set(i, stack);
            if (!this.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
                stack.setCount(this.getMaxStackSize());
            }
            this.setChanged();
        }

        public boolean stillValid(@NotNull Player player) {
            return true;
        }

        public void clearContent() {
            this.setItems((List<ItemStack>)NonNullList.withSize((int)this.size, (Object)ItemStack.EMPTY));
        }

        public boolean containsItem(Item item) {
            return this.getItems().stream().anyMatch(itemStack -> itemStack.getItem().equals(item));
        }

        public boolean canAddItem(ItemStack stack) {
            boolean flag = false;
            for (ItemStack itemstack : this.getItems()) {
                if (!itemstack.isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack) || itemstack.getCount() >= itemstack.getMaxStackSize())) continue;
                flag = true;
                break;
            }
            return flag;
        }

        public ItemStack addItem(ItemStack stack) {
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            ItemStack itemstack = stack.copy();
            this.moveItemToOccupiedSlotsWithSameType(itemstack);
            if (itemstack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            this.moveItemToEmptySlots(itemstack);
            return itemstack.isEmpty() ? ItemStack.EMPTY : itemstack;
        }

        private void moveItemToOccupiedSlotsWithSameType(ItemStack stack) {
            for (int i = 0; i < this.size; ++i) {
                ItemStack itemstack = this.getItem(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack)) continue;
                this.moveItemsBetweenStacks(stack, itemstack);
                if (!stack.isEmpty()) continue;
                return;
            }
        }

        private void moveItemsBetweenStacks(ItemStack stack, ItemStack other) {
            int i = this.getMaxStackSize(other);
            int j = Math.min(stack.getCount(), i - other.getCount());
            if (j > 0) {
                other.grow(j);
                stack.shrink(j);
                this.setChanged();
            }
        }

        private void moveItemToEmptySlots(ItemStack stack) {
            for (int i = 0; i < this.size; ++i) {
                ItemStack itemstack = this.getItem(i);
                if (!itemstack.isEmpty()) continue;
                this.setItem(i, stack.copyAndClear());
                return;
            }
        }

        public ItemStack removeItemType(Item item, int amount) {
            ItemStack itemstack = new ItemStack((ItemLike)item, 0);
            for (int i = this.size - 1; i >= 0; --i) {
                ItemStack itemstack1 = this.getItem(i);
                if (!itemstack1.getItem().equals(item)) continue;
                int j = amount - itemstack.getCount();
                ItemStack itemstack2 = itemstack1.split(j);
                itemstack.grow(itemstack2.getCount());
                if (itemstack.getCount() == amount) break;
            }
            if (!itemstack.isEmpty()) {
                this.setChanged();
            }
            return itemstack;
        }

        @NotNull
        public Component getName() {
            return Machine.this.getName();
        }

        public void fillStackedContents(@NotNull StackedContents helper) {
            for (ItemStack itemstack : this.getItems()) {
                helper.accountStack(itemstack);
            }
        }
    }
}

