/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.projectile;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import ru.magistu.siegemachines.item.ModItems;
import ru.magistu.siegemachines.util.CombatUtil;

public class GiantArrow
extends AbstractArrow {
    public GiantArrow(EntityType<GiantArrow> type, Level level) {
        super(type, level);
    }

    public GiantArrow(EntityType<GiantArrow> entitytype, Level level, Vector3d pos, LivingEntity shooter, Entity engine, ItemStack item) {
        super(entitytype, shooter.getControllingPassenger() != null ? shooter.getControllingPassenger() : shooter, level, item, null);
        this.setPos(pos.x, pos.y, pos.z);
        this.setBaseDamage(5.0);
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.GIANT_ARROW.get());
    }

    protected void onHitEntity(EntityHitResult result) {
        if (CombatUtil.canHurt(this.getOwner(), result.getEntity())) {
            super.onHitEntity(result);
        }
    }
}

