/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import ru.magistu.siegemachines.ModTags;
import ru.magistu.siegemachines.config.SpecsConfig;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.projectile.FlightType;
import ru.magistu.siegemachines.entity.projectile.MachineBasedExplosionDamageCalculator;
import ru.magistu.siegemachines.entity.projectile.MissileExplosion;
import ru.magistu.siegemachines.entity.projectile.MissileType;
import ru.magistu.siegemachines.util.CombatUtil;

public abstract class Missile
extends ThrowableItemProjectile {
    public MissileType type = MissileType.STONE;
    protected Entity engine = null;

    public Missile(EntityType<? extends Missile> entitytype, Level level) {
        super(entitytype, level);
    }

    public Missile(EntityType<? extends Missile> entitytype, Level level, Vector3d pos, LivingEntity entity, Entity engine, MissileType type) {
        super(entitytype, entity.getControllingPassenger() != null ? entity.getControllingPassenger() : entity, level);
        this.type = type;
        this.engine = engine;
        this.setPos(pos.x, pos.y, pos.z);
    }

    public void onHit(HitResult result) {
        Entity entity;
        if (result.getType() == HitResult.Type.ENTITY) {
            Vec3 vector3d;
            EntityHitResult entityRTR = (EntityHitResult)result;
            Vec3 pos = entityRTR.getLocation();
            Entity entity2 = entityRTR.getEntity();
            float damage = (float)((Double)this.type.specs.mass.get() * this.getDeltaMovement().length());
            DamageSource damagesource = this.damageSources().thrown((Entity)this, this.getOwner());
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity2;
                damage += this.type.armorpiercing * (damage - CombatRules.getDamageAfterAbsorb((LivingEntity)livingentity, (float)damage, (DamageSource)damagesource, (float)livingentity.getArmorValue(), (float)((float)livingentity.getAttribute(Attributes.ARMOR_TOUGHNESS).getValue())));
            }
            if (!this.level().isClientSide() && this.type.explosive) {
                this.explode(pos.x, pos.y, pos.z, Explosion.BlockInteraction.DESTROY);
                this.remove(Entity.RemovalReason.KILLED);
            }
            if (this.canHurt(entity2)) {
                entity2.hurt(damagesource, damage);
            }
            if ((vector3d = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.type.knockback * 0.6)).lengthSqr() > 0.0) {
                entity2.push(vector3d.x, 0.1, vector3d.z);
            }
        }
        if (result.getType() == HitResult.Type.BLOCK) {
            boolean smoothimpact;
            BlockHitResult blockRTR = (BlockHitResult)result;
            BlockPos blockpos = blockRTR.getBlockPos();
            BlockState blockstate = this.level().getBlockState(blockpos);
            boolean bl = smoothimpact = (Boolean)SpecsConfig.ENABLE_SMOOTH_IMPACT.get() != false && blockstate.is(ModTags.Blocks.SMOOTH_IMPACT) && blockRTR.getDirection() == Direction.UP;
            if (blockRTR.getDirection() == Direction.UP) {
                if (this.type.explosive) {
                    int r = 0;
                    while ((double)r < (Double)this.type.specs.explosionpower.get()) {
                        for (int a = 0; a < 8; ++a) {
                            float i = (float)((double)a * Math.PI / 4.0);
                            BlockPos pos = blockRTR.getBlockPos();
                            BlockPos pos2 = BlockPos.containing((double)((float)pos.getX() + (float)r * Mth.cos((float)i)), (double)pos.getY(), (double)((float)pos.getZ() - (float)r * Mth.sin((float)i)));
                            if (this.level().getBlockState(pos2) != Blocks.GRASS_BLOCK.defaultBlockState()) continue;
                            this.level().setBlockAndUpdate(pos2, Blocks.DIRT.defaultBlockState());
                        }
                        ++r;
                    }
                }
                if (!this.level().isClientSide()) {
                    this.discard();
                    if (smoothimpact && this.type.explosive) {
                        this.explode(blockpos.getX(), blockpos.getY(), blockpos.getZ(), Explosion.BlockInteraction.KEEP);
                    }
                } else if (smoothimpact) {
                    this.dustExplosion((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), blockpos, (Double)this.type.specs.explosionpower.get() / 2.0, 50);
                }
            }
            if (!this.level().isClientSide() && !smoothimpact && this.type.explosive) {
                this.explode(blockpos.getX(), blockpos.getY(), blockpos.getZ(), Explosion.BlockInteraction.DESTROY);
            }
        }
        if (result.getType() == HitResult.Type.MISS && (entity = this.getOwner()) instanceof Player) {
            Player player = (Player)entity;
            this.level().playSound(player, this.getOnPos(), SoundEvents.ANVIL_BREAK, SoundSource.AMBIENT, 1.0f, 1.0f);
            if (!this.level().isClientSide()) {
                this.discard();
            }
        }
        if (!this.level().isClientSide()) {
            this.discard();
        }
    }

    public boolean canHurt(Entity victim) {
        return CombatUtil.canHurt(this.getOwner(), victim);
    }

    private void dustExplosion(ParticleOptions particle, BlockPos blockpos, double speed, int amount) {
        this.dustExplosion(particle, blockpos.getX(), blockpos.getY(), blockpos.getZ(), speed, amount);
    }

    private void dustExplosion(ParticleOptions particle, double x, double y, double z, double speed, int amount) {
        for (int i = 0; i < amount; ++i) {
            Vec3 movement = this.getDeltaMovement();
            double d0 = x - 0.05 + this.level().random.nextDouble() * 0.3;
            double d1 = y + 1.0;
            double d2 = z - 0.05 + this.level().random.nextDouble() * 0.3;
            double d3 = movement.x * this.level().random.nextDouble() * speed;
            double d4 = -movement.y * this.level().random.nextDouble() * speed * 10.0;
            double d5 = movement.z * this.level().random.nextDouble() * speed;
            this.level().addParticle(particle, d0, d1, d2, d3, d4, d5);
        }
    }

    public void tick() {
        if (this.type.flighttype == FlightType.SPINNING) {
            this.setXRot(this.getXRot() + 0.5f);
        }
        super.tick();
    }

    public MissileExplosion explode(double x, double y, double z, Explosion.BlockInteraction mode) {
        return this.explode(x, y, z, false, mode);
    }

    public MissileExplosion explode(double x, double y, double z, boolean fired, Explosion.BlockInteraction mode) {
        Entity source = this.getOwner();
        float size = ((Double)this.type.specs.explosionpower.get()).floatValue();
        if (this.engine != null) {
            size *= 2.0f;
        }
        Entity directSource = this.getDirectSourceEntityInternal(source);
        LivingEntity indirectSource = Missile.getIndirectSourceEntityInternal(source);
        MissileExplosion explosion = new MissileExplosion(this.level(), source, this.level().damageSources().explosion(directSource, (Entity)indirectSource), this.getExplosionDamageCalculator(), x, y, z, size, fired, mode, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder<SoundEvent>)SoundEvents.GENERIC_EXPLODE);
        explosion.explode();
        explosion.finalizeExplosion(true);
        return explosion;
    }

    @Nullable
    private Entity getDirectSourceEntityInternal(@Nullable Entity source) {
        return source == null ? this : (source.getVehicle() == null ? source : source.getVehicle());
    }

    private ExplosionDamageCalculator getExplosionDamageCalculator() {
        if (this.engine == null) {
            return new ExplosionDamageCalculator();
        }
        Entity entity = this.engine;
        if (entity instanceof Machine) {
            Machine machine = (Machine)entity;
            return new MachineBasedExplosionDamageCalculator(machine);
        }
        return new EntityBasedExplosionDamageCalculator(this.engine);
    }

    @Nullable
    private static LivingEntity getIndirectSourceEntityInternal(@Nullable Entity source) {
        Projectile projectile;
        Entity entity;
        if (source == null) {
            return null;
        }
        if (source instanceof PrimedTnt) {
            PrimedTnt primedtnt = (PrimedTnt)source;
            return primedtnt.getOwner();
        }
        if (source instanceof Machine) {
            Machine machine = (Machine)source;
            return machine.getControllingPassenger();
        }
        if (source instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)source;
            return livingentity;
        }
        if (source instanceof Projectile && (entity = (projectile = (Projectile)source).getOwner()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            return livingentity;
        }
        return null;
    }
}

