/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.util;

import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class HitUtil {
    public static HitResult getBlockHitResult(Vec3 from, Vec3 delta, Level level, ClipContext.Block clipcontext) {
        Vec3 to = from.add(delta);
        return level.clip(new ClipContext(from, to, clipcontext, ClipContext.Fluid.NONE, CollisionContext.empty()));
    }

    public static HitResult getHitResult(Vec3 from, Entity entity, Predicate<Entity> filter, Vec3 delta, Level level, float margin, ClipContext.Block clipcontext) {
        EntityHitResult entityhit;
        Vec3 to = from.add(delta);
        BlockHitResult blockhit = level.clip(new ClipContext(from, to, clipcontext, ClipContext.Fluid.NONE, CollisionContext.empty()));
        if (blockhit.getType() != HitResult.Type.MISS) {
            to = blockhit.getLocation();
        }
        if ((entityhit = ProjectileUtil.getEntityHitResult((Level)level, (Entity)entity, (Vec3)from, (Vec3)to, (AABB)new AABB(from, to).inflate(1.0), filter, (float)margin)) != null) {
            return entityhit;
        }
        return blockhit;
    }
}

