/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.projectile;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import ru.magistu.siegemachines.entity.Explosive;
import ru.magistu.siegemachines.entity.projectile.ExplosiveBasedExplosionDamageCalculator;
import ru.magistu.siegemachines.entity.projectile.FlightType;
import ru.magistu.siegemachines.entity.projectile.MissileExplosion;
import ru.magistu.siegemachines.entity.projectile.MissileType;
import ru.magistu.siegemachines.util.CombatUtil;

public abstract class Missile
extends ThrowableItemProjectile
implements Explosive {
    public MissileType type = MissileType.STONE;
    protected Entity engine = null;
    private final ExplosiveBasedExplosionDamageCalculator explosionDamageCalculator = new ExplosiveBasedExplosionDamageCalculator(this);
    private static final Map<Block, Block> BLOCK_CRACKING_MAP = Map.of(Blocks.STONE_BRICKS, Blocks.CRACKED_STONE_BRICKS, Blocks.INFESTED_STONE_BRICKS, Blocks.CRACKED_STONE_BRICKS, Blocks.DEEPSLATE_BRICKS, Blocks.CRACKED_DEEPSLATE_BRICKS, Blocks.DEEPSLATE_TILES, Blocks.CRACKED_DEEPSLATE_TILES, Blocks.NETHER_BRICKS, Blocks.CRACKED_NETHER_BRICKS, Blocks.STONE, Blocks.COBBLESTONE, Blocks.DEEPSLATE, Blocks.COBBLED_DEEPSLATE, Blocks.GRASS_BLOCK, Blocks.DIRT);
    protected static final int MISSILE_EXPLOSION = 66;

    public Missile(EntityType<? extends Missile> entitytype, Level level) {
        super(entitytype, level);
    }

    public Missile(EntityType<? extends Missile> entitytype, Level level, Vector3d pos, LivingEntity entity, Entity engine, MissileType type) {
        super(entitytype, entity.getControllingPassenger() != null ? entity.getControllingPassenger() : entity, level);
        this.type = type;
        this.engine = engine;
        this.setPos(pos.x, pos.y, pos.z);
    }

    public void onHit(HitResult hit) {
        switch (hit.getType()) {
            case ENTITY: {
                this.handleEntityHit((EntityHitResult)hit);
                break;
            }
            case BLOCK: {
                this.handleBlockHit((BlockHitResult)hit);
                break;
            }
            case MISS: {
                this.handleMiss();
            }
        }
        if (!this.level().isClientSide()) {
            this.discard();
        }
    }

    protected void handleEntityHit(EntityHitResult entityHit) {
        Vec3 pos = entityHit.getLocation();
        Entity victim = entityHit.getEntity();
        float damage = (float)((Double)this.type.specs.mass.get() * this.getDeltaMovement().length() / 10.0);
        DamageSource damageSource = this.damageSources().thrown((Entity)this, this.getIndirectSourceEntityInternal());
        if (victim instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)victim;
            float armor = CombatRules.getDamageAfterAbsorb((LivingEntity)livingEntity, (float)damage, (DamageSource)damageSource, (float)livingEntity.getArmorValue(), (float)((float)livingEntity.getAttribute(Attributes.ARMOR_TOUGHNESS).getValue()));
            damage += ((Double)this.type.specs.armorpiercing.get()).floatValue() * (damage - armor);
        }
        if (!this.level().isClientSide() && ((Boolean)this.type.specs.explosive.get()).booleanValue()) {
            this.explode(pos.subtract(this.getDeltaMovement().normalize().scale(0.5)), Explosion.BlockInteraction.DESTROY);
        }
        if (this.canHurt(victim)) {
            victim.hurt(damageSource, damage);
            this.applyKnockback(victim);
        }
    }

    private void applyKnockback(Entity entity) {
        Vec3 knockbackVec;
        double knockback = (Double)this.type.specs.knockback.get();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            knockback *= 1.0 - livingentity.getAttributeValue(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE);
        }
        if ((knockbackVec = this.getDeltaMovement().normalize().scale(knockback)).lengthSqr() > 0.0) {
            entity.push(knockbackVec.x, knockbackVec.y, knockbackVec.z);
        }
    }

    protected void handleBlockHit(BlockHitResult blockHit) {
        Vec3 pos = blockHit.getLocation();
        if (!this.level().isClientSide() && ((Boolean)this.type.specs.explosive.get()).booleanValue()) {
            Explosion.BlockInteraction interaction = this.getExplosionBlockInteraction();
            this.explode(pos.relative(blockHit.getDirection(), 0.5), interaction);
        }
    }

    private Explosion.BlockInteraction getExplosionBlockInteraction() {
        return this.level().getGameRules().getBoolean(GameRules.RULE_MOB_EXPLOSION_DROP_DECAY) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }

    private void crackBlocks(BlockPos origin) {
        int r = 0;
        while ((double)r < 1.5 * (Double)this.type.specs.explosionpower.get()) {
            for (int a = 0; a < 8; ++a) {
                for (int b = 0; b < 8; ++b) {
                    float phi = (float)((double)a * Math.PI / 4.0);
                    float theta = (float)((double)b * Math.PI / 4.0);
                    int dx = (int)((double)r * Math.sin(theta) * Math.cos(phi));
                    int dy = (int)((double)r * Math.cos(theta));
                    int dz = (int)((double)r * Math.sin(theta) * Math.sin(phi));
                    BlockPos pos2 = origin.offset(dx, dy, dz);
                    Block crackedBlock = BLOCK_CRACKING_MAP.get(this.level().getBlockState(pos2).getBlock());
                    if (crackedBlock == null) continue;
                    this.level().setBlockAndUpdate(pos2, crackedBlock.defaultBlockState());
                }
            }
            ++r;
        }
    }

    protected void handleMiss() {
    }

    public boolean canHurt(Entity victim) {
        return CombatUtil.canHurt(this.getOwner(), victim);
    }

    public void tick() {
        if (this.type.flighttype == FlightType.SPINNING) {
            this.setXRot(this.getXRot() + 0.5f);
        }
        super.tick();
    }

    public Explosion explode(Vec3 pos, Explosion.BlockInteraction mode) {
        Entity source = this.getOwner();
        float size = this.getExplosionPower();
        Entity indirectSource = this.getIndirectSourceEntityInternal();
        double x = pos.x;
        double y = pos.y;
        double z = pos.z;
        boolean fired = (Boolean)this.type.specs.fired.get();
        MissileExplosion explosion = new MissileExplosion(this.level(), source, this.damageSources().explosion((Entity)this, indirectSource), this.explosionDamageCalculator, x, y, z, size, fired, mode, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder<SoundEvent>)SoundEvents.GENERIC_EXPLODE);
        this.crackBlocks(new BlockPos((int)x, (int)y, (int)z));
        explosion.explode();
        explosion.finalizeExplosion(true);
        this.level().broadcastEntityEvent((Entity)this, (byte)66);
        return explosion;
    }

    protected float getExplosionPower() {
        float defaultPower = ((Double)this.type.specs.explosionpower.get()).floatValue();
        float speed = (float)this.getDeltaMovement().length();
        float power = (float)((double)(defaultPower * 0.3f) + Math.log1p(speed) * (double)defaultPower * 0.5);
        return Mth.clamp((float)power, (float)(defaultPower * 0.7f), (float)(defaultPower * 1.5f));
    }

    @Override
    public float getBlockResistance(Explosion explosion, BlockGetter level, BlockPos pos, BlockState blockState, FluidState fluidState, float resistance) {
        if (BLOCK_CRACKING_MAP.containsValue(level.getBlockState(pos).getBlock())) {
            resistance *= 0.83f;
        }
        float speed = (float)this.getDeltaMovement().length();
        float power = (float)(0.5 + Math.log1p(speed) * 0.5);
        return resistance / Mth.clamp((float)power, (float)0.7f, (float)1.5f);
    }

    @Override
    public double getExplosionDamageMultiplier() {
        double defaultMultiplier = (Double)this.type.specs.explosiondamagemultiplier.get();
        double speed = this.getDeltaMovement().length();
        double multiplier = defaultMultiplier * 0.33 + Math.log1p(speed) * defaultMultiplier * 0.5;
        return Mth.clamp((double)multiplier, (double)(defaultMultiplier * 0.7), (double)(defaultMultiplier * 1.5));
    }

    @Override
    public boolean shouldDamageEntity(Explosion explosion, Entity victim) {
        return CombatUtil.canHurt(this.getOwner(), victim);
    }

    @Override
    public boolean shouldBlockDestroy(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, float power) {
        return true;
    }

    @Nullable
    private Entity getIndirectSourceEntityInternal() {
        return this.getOwner() != null ? this.getOwner() : this.engine;
    }

    public void handleEntityEvent(byte id) {
        if (id == 66 && this.level().isClientSide()) {
            this.explode(this.position(), Explosion.BlockInteraction.KEEP);
        } else {
            super.handleEntityEvent(id);
        }
    }
}

