/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.plugin.jei;

import java.util.Arrays;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import ru.magistu.siegemachines.block.ModBlocks;
import ru.magistu.siegemachines.item.recipes.SiegeWorkbenchRecipe;

public class SiegeWorkbenchRecipeCategory
implements IRecipeCategory<SiegeWorkbenchRecipe> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"siegemachines", (String)"textures/gui/siege_workbench.png");
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"siegemachines", (String)"siege_workbench_recipe_category");
    public static final RecipeType<SiegeWorkbenchRecipe> RECIPE_TYPE = new RecipeType(UID, SiegeWorkbenchRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public SiegeWorkbenchRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 29, 16, 116, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.SIEGE_WORKBENCH.get()));
    }

    public RecipeType<SiegeWorkbenchRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"category.siegemachines.siege_workbench_crafting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull SiegeWorkbenchRecipe recipe, @Nonnull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 94, 18).addItemStack(recipe.getResultItem(null));
        NonNullList grid = recipe.getIngredients();
        for (int i = 0; i < recipe.getWidth(); ++i) {
            for (int j = 0; j < recipe.getHeight(); ++j) {
                Ingredient ingredient = (Ingredient)grid.get(i + j * 3);
                builder.addSlot(RecipeIngredientRole.INPUT, i * 18, j * 18).addItemStacks(Arrays.stream(ingredient.getItems()).toList());
            }
        }
    }
}

