/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.client;

import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import ru.magistu.siegemachines.SiegeMachines;
import ru.magistu.siegemachines.client.ClientProxy;
import ru.magistu.siegemachines.client.KeyBindings;
import ru.magistu.siegemachines.client.renderer.GiantArrowRenderer;
import ru.magistu.siegemachines.client.renderer.MachineGeoRenderer;
import ru.magistu.siegemachines.client.renderer.SeatRenderer;
import ru.magistu.siegemachines.client.renderer.model.BallistaModel;
import ru.magistu.siegemachines.client.renderer.model.BatteringRamGeoModel;
import ru.magistu.siegemachines.client.renderer.model.CatapultModel;
import ru.magistu.siegemachines.client.renderer.model.CulverinModel;
import ru.magistu.siegemachines.client.renderer.model.MortarModel;
import ru.magistu.siegemachines.client.renderer.model.SiegeLadderModel;
import ru.magistu.siegemachines.client.renderer.model.TrebuchetModel;
import ru.magistu.siegemachines.entity.ModEntityTypes;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.machine.SiegeLadder;
import ru.magistu.siegemachines.gui.machine.crosshair.Crosshair;
import ru.magistu.siegemachines.item.MachineItem;
import ru.magistu.siegemachines.item.ModItems;
import ru.magistu.siegemachines.network.C2SPacketMachineUse;
import ru.magistu.siegemachines.network.ModNetwork;
import ru.magistu.siegemachines.network.PacketOpenMachineInventory;

public class ClientProxyForge {
    static LayeredDraw.Layer layer = (guiGraphics, deltaTracker) -> {
        Crosshair crosshair;
        Minecraft mc = Minecraft.getInstance();
        Options settings = mc.options;
        LocalPlayer player = mc.player;
        if (player == null || settings.hideGui || settings.getCameraType() != CameraType.FIRST_PERSON) {
            return;
        }
        Entity vehicle = player.getVehicle();
        if (vehicle != null && (crosshair = ClientProxy.CROSSHAIR_FACTORIES.get(vehicle.getType())) != null) {
            crosshair.render(guiGraphics, deltaTracker);
        }
    };

    public static void setup(IEventBus modEventBus) {
        modEventBus.addListener(ClientProxyForge::clientSetup);
        modEventBus.addListener(ClientProxyForge::registerRenderers);
        modEventBus.addListener(ClientProxyForge::extensions);
        modEventBus.addListener(ClientProxyForge::registerOverlay);
        modEventBus.addListener(ClientProxyForge::onKeyRegister);
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        ClientProxy.setup();
        NeoForge.EVENT_BUS.addListener(ClientProxyForge::onKeyPressedEvent);
        NeoForge.EVENT_BUS.addListener(ClientProxyForge::onRenderOverlay);
    }

    public static void extensions(RegisterClientExtensionsEvent event) {
        for (RegistrySupplier supplier : ModItems.ITEMS) {
            Item item = (Item)supplier.get();
            if (!(item instanceof MachineItem)) continue;
            final MachineItem machineItem = (MachineItem)item;
            event.registerItem(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return machineItem.getRenderer();
                }
            }, new Item[]{machineItem});
        }
    }

    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntityTypes.MORTAR.get(), context -> new MachineGeoRenderer(context, new MortarModel(SiegeMachines.id("mortar"))));
        event.registerEntityRenderer((EntityType)ModEntityTypes.CULVERIN.get(), context -> new MachineGeoRenderer(context, new CulverinModel(SiegeMachines.id("culverin"))));
        event.registerEntityRenderer((EntityType)ModEntityTypes.TREBUCHET.get(), context -> new MachineGeoRenderer(context, new TrebuchetModel(SiegeMachines.id("trebuchet"))));
        event.registerEntityRenderer((EntityType)ModEntityTypes.CATAPULT.get(), context -> new MachineGeoRenderer(context, new CatapultModel(SiegeMachines.id("catapult"))));
        event.registerEntityRenderer((EntityType)ModEntityTypes.BALLISTA.get(), context -> new MachineGeoRenderer(context, new BallistaModel(SiegeMachines.id("ballista"))));
        event.registerEntityRenderer((EntityType)ModEntityTypes.BATTERING_RAM.get(), context -> new MachineGeoRenderer(context, new BatteringRamGeoModel(SiegeMachines.id("battering_ram"))));
        event.registerEntityRenderer((EntityType)ModEntityTypes.SIEGE_LADDER.get(), context -> new MachineGeoRenderer(context, new SiegeLadderModel(SiegeMachines.id("siege_ladder"))));
        event.registerEntityRenderer((EntityType)ModEntityTypes.CANNONBALL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.GIANT_STONE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.STONE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.GIANT_ARROW.get(), GiantArrowRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.SEAT.get(), SeatRenderer::new);
    }

    public static void onKeyPressedEvent(InputEvent.Key ev) {
        Machine machine;
        Entity entity;
        LocalPlayer player;
        if (KeyBindings.MACHINE_USE.isDown() && (player = Minecraft.getInstance().player) != null && player.isPassenger() && (entity = player.getVehicle()) instanceof Machine && !((machine = (Machine)entity) instanceof SiegeLadder)) {
            ModNetwork.sendToServer(new C2SPacketMachineUse());
        }
        if (KeyBindings.LADDER_CLIMB.isDown() && (player = Minecraft.getInstance().player) != null && player.isPassenger() && player.getVehicle() instanceof SiegeLadder) {
            ModNetwork.sendToServer(new C2SPacketMachineUse());
        }
        if (KeyBindings.MACHINE_INVENTORY.isDown() && (player = Minecraft.getInstance().player) != null && player.isPassenger() && player.getVehicle() instanceof Machine) {
            ModNetwork.sendToServer(new PacketOpenMachineInventory());
        }
    }

    public static void onRenderOverlay(RenderGuiLayerEvent.Pre ev) {
        Entity entity;
        LocalPlayer player;
        ResourceLocation name = ev.getName();
        if (name.equals((Object)VanillaGuiLayers.CROSSHAIR) && (player = Minecraft.getInstance().player) != null && (entity = player.getVehicle()) != null && ClientProxy.CROSSHAIR_FACTORIES.containsKey(entity.getType())) {
            ev.setCanceled(true);
        }
    }

    public static void registerOverlay(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, SiegeMachines.id("crosshair"), layer);
    }

    public static void onKeyRegister(RegisterKeyMappingsEvent ev) {
        ev.register(KeyBindings.MACHINE_USE);
        ev.register(KeyBindings.LADDER_CLIMB);
        ev.register(KeyBindings.MACHINE_INVENTORY);
    }
}

