/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import ru.magistu.siegemachines.entity.machine.BatteringRam;
import ru.magistu.siegemachines.entity.machine.Cannon;
import ru.magistu.siegemachines.entity.machine.Catapult;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.machine.Seat;
import ru.magistu.siegemachines.entity.machine.SiegeLadder;
import ru.magistu.siegemachines.entity.projectile.Cannonball;
import ru.magistu.siegemachines.entity.projectile.GiantArrow;
import ru.magistu.siegemachines.entity.projectile.GiantStone;
import ru.magistu.siegemachines.entity.projectile.Stone;

public class ModEntityTypes {
    public static final DeferredRegister<EntityType<?>> DEFERRED_REGISTER = DeferredRegister.create((String)"siegemachines", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<EntityType<Cannonball>> CANNONBALL = ModEntityTypes.addRegistry("cannonball", Cannonball::new, 1.0f, 1.0f, 20);
    public static final RegistrySupplier<EntityType<Stone>> STONE = ModEntityTypes.addRegistry("stone", Stone::new, 1.0f, 1.0f, 20);
    public static final RegistrySupplier<EntityType<GiantStone>> GIANT_STONE = ModEntityTypes.addRegistry("giant_stone", GiantStone::new, 2.0f, 2.0f, 20);
    public static final RegistrySupplier<EntityType<GiantArrow>> GIANT_ARROW = DEFERRED_REGISTER.register("giant_arrow", () -> EntityType.Builder.of(GiantArrow::new, (MobCategory)MobCategory.MISC).clientTrackingRange(4).updateInterval(20).sized(0.5f, 0.5f).build(""));
    public static final RegistrySupplier<EntityType<Cannon>> MORTAR = ModEntityTypes.addRegistry("mortar", (entitytype, level) -> new Cannon((EntityType<? extends Mob>)entitytype, level, MachineType.MORTAR), 2.0f, 1.0f, 10);
    public static final RegistrySupplier<EntityType<Cannon>> CULVERIN = ModEntityTypes.addRegistry("culverin", (entitytype, level) -> new Cannon((EntityType<? extends Mob>)entitytype, level, MachineType.CULVERIN), 2.5f, 1.8f, 10);
    public static final RegistrySupplier<EntityType<Catapult>> TREBUCHET = ModEntityTypes.addRegistry("trebuchet", (entitytype, level) -> new Catapult((EntityType<? extends Mob>)entitytype, level, MachineType.TREBUCHET), 5.0f, 9.0f, 10);
    public static final RegistrySupplier<EntityType<Catapult>> CATAPULT = ModEntityTypes.addRegistry("catapult", (entitytype, level) -> new Catapult((EntityType<? extends Mob>)entitytype, level, MachineType.CATAPULT), 3.0f, 3.0f, 10);
    public static final RegistrySupplier<EntityType<Catapult>> BALLISTA = ModEntityTypes.addRegistry("ballista", (entitytype, level) -> new Catapult((EntityType<? extends Mob>)entitytype, level, MachineType.BALLISTA), 1.5f, 1.5f, 10);
    public static final RegistrySupplier<EntityType<BatteringRam>> BATTERING_RAM = ModEntityTypes.addRegistry("battering_ram", BatteringRam::new, 4.0f, 3.0f, 10);
    public static final RegistrySupplier<EntityType<SiegeLadder>> SIEGE_LADDER = ModEntityTypes.addRegistry("siege_ladder", SiegeLadder::new, 3.0f, 3.0f, 10);
    public static final RegistrySupplier<EntityType<Seat>> SEAT = ModEntityTypes.addRegistry("seat", Seat::new, 0.0f, 0.0f);

    public static <T extends Entity> RegistrySupplier<EntityType<T>> addRegistry(String name, EntityType.EntityFactory<T> constructor, float sizex, float sizey) {
        return ModEntityTypes.addRegistry(name, constructor, sizex, sizey, 1);
    }

    public static <T extends Entity> RegistrySupplier<EntityType<T>> addRegistry(String name, EntityType.EntityFactory<T> constructor, float sizex, float sizey, int trackingrange) {
        return DEFERRED_REGISTER.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)constructor, (MobCategory)MobCategory.MISC).clientTrackingRange(trackingrange).sized(sizex, sizey).build(""));
    }

    public static void register() {
        DEFERRED_REGISTER.register();
    }
}

