/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import ru.magistu.siegemachines.api.enitity.Useable;
import ru.magistu.siegemachines.entity.machine.LadderSeat;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.platform.Services;
import ru.magistu.siegemachines.util.CartesianGeometry;
import ru.magistu.siegemachines.util.HitUtil;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SiegeLadder
extends Machine
implements GeoEntity {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Vec3 CLIMB_VECTOR = new Vec3(0.0, 130.0, 130.0).scale(0.0625);
    private static final Vec3 CLIMB_PIVOT_1 = new Vec3(-8.0, 0.0, -37.0).scale(0.0625);
    private static final Vec3 CLIMB_PIVOT_2 = new Vec3(8.0, 0.0, -37.0).scale(0.0625);
    private static final int NUMBER_OF_SEATS = 16;
    private final List<LadderSeat> leftseats = Stream.generate(() -> new LadderSeat(this)).limit(8L).collect(Collectors.toList());
    private final List<LadderSeat> rightseats = Stream.generate(() -> new LadderSeat(this)).limit(8L).collect(Collectors.toList());
    public final List<LadderSeat> seats = Stream.of(this.leftseats, this.rightseats).flatMap(Collection::stream).collect(Collectors.toList());
    private double lastwheelpitch;
    private double wheelspitch = 0.0;

    public SiegeLadder(EntityType<? extends Mob> entitytype, Level level) {
        super(entitytype, level, MachineType.SIEGE_LADDER);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.level().isClientSide() || player.isPassenger()) {
            return InteractionResult.PASS;
        }
        if (!this.isVehicle()) {
            player.startRiding((Entity)this);
            return InteractionResult.SUCCESS;
        }
        LadderSeat seat = this.getFreeSeat((LivingEntity)player);
        if (seat != null) {
            player.startRiding((Entity)seat);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void travel(Vec3 velocity) {
        if (this.isAlive()) {
            if (this.hasControllingPassenger()) {
                LivingEntity livingentity = this.getControllingPassenger();
                float f1 = livingentity.zza;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.setSpeed(0.04f);
                velocity = new Vec3(0.0, velocity.y, (double)f1);
            }
            super.travel(velocity);
        }
    }

    @Override
    public void tick() {
        this.lastwheelpitch = this.wheelspitch;
        this.wheelspitch += this.getWheelsSpeed();
        this.seatsTick();
        super.tick();
    }

    public double getLerpedWheelPitch(float partialTick) {
        return Mth.lerp((double)partialTick, (double)this.lastwheelpitch, (double)this.wheelspitch);
    }

    public void seatsTick() {
        this.leftseats.forEach(seat -> this.updateSeatPosition((LadderSeat)((Object)seat), true));
        this.rightseats.forEach(seat -> this.updateSeatPosition((LadderSeat)((Object)seat), false));
    }

    @Override
    protected boolean canDropAsItem() {
        return super.canDropAsItem() && this.seats.stream().noneMatch(Entity::isVehicle);
    }

    public void updateSeatPosition(LadderSeat seat, boolean left) {
        HitResult hit;
        double yaw = (double)this.getYRot() * Math.PI / 180.0;
        float highness = seat.climb();
        Vec3 origin = this.getSeatOrigin(left, yaw);
        Vec3 pos = origin.add(CartesianGeometry.applyRotations(CLIMB_VECTOR.scale((double)highness), 0.0, yaw));
        Optional freepos = this.level().findFreePosition((Entity)seat, Shapes.create((AABB)AABB.ofSize((Vec3)pos, (double)0.1, (double)0.1, (double)0.1)), pos, 0.0, 0.0, 0.0);
        if (freepos.isPresent() && pos.distanceTo((Vec3)freepos.get()) < 0.5) {
            seat.setHighness(highness);
            pos = (Vec3)freepos.get();
        }
        if (seat.isVehicle() && (hit = HitUtil.getBlockHitResult(origin, pos.subtract(origin), this.level(), ClipContext.Block.COLLIDER)).getType() != HitResult.Type.MISS) {
            highness = (float)(hit.getLocation().subtract(origin).length() / CLIMB_VECTOR.length());
            seat.setHighness(highness);
            pos = hit.getLocation();
        }
        seat.moveTo(pos);
    }

    private Vec3 getSeatOrigin(boolean left, double yaw) {
        return this.position().add(CartesianGeometry.applyRotations(left ? CLIMB_PIVOT_1 : CLIMB_PIVOT_2, 0.0, yaw));
    }

    public void remove(Entity.RemovalReason reason) {
        for (LadderSeat seat : this.seats) {
            seat.discard();
        }
        super.remove(reason);
    }

    @Override
    public void use(LivingEntity entity) {
        LadderSeat seat;
        if (this.getControllingPassenger() == entity && (seat = this.getFreeSeat(entity)) != null) {
            entity.startRiding((Entity)seat);
        }
    }

    @Override
    public void useRelease() {
    }

    public double getWheelsSpeed() {
        if (this.onGround()) {
            return this.getViewVector(5.0f).multiply(1.0, 0.0, 1.0).dot(this.getDeltaMovement());
        }
        return 0.0;
    }

    @Nullable
    protected LadderSeat getFreeSeat(LivingEntity entity) {
        long l2;
        AtomicReference<Object> left = new AtomicReference<Object>(null);
        AtomicReference<Object> right = new AtomicReference<Object>(null);
        long l1 = this.leftseats.stream().filter(seat -> {
            if (seat.isVehicle()) {
                return true;
            }
            left.set(seat);
            return false;
        }).count();
        if (l1 < (l2 = this.rightseats.stream().filter(seat -> {
            if (seat.isVehicle()) {
                return true;
            }
            right.set(seat);
            return false;
        }).count())) {
            return left.get();
        }
        if (l1 == l2 && entity != null) {
            Vec3 view = this.getViewVector(0.0f);
            return entity.position().subtract(this.position()).dot(new Vec3(view.z, 0.0, -view.x).normalize()) > 0.0 ? (LadderSeat)right.get() : (LadderSeat)left.get();
        }
        return right.get();
    }

    public void push(Entity entity) {
    }

    public void push(double x, double y, double z) {
    }

    public void onAddedToLevel() {
        Services.PLATFORM.onAddedToLevel((Entity)this);
        this.seats.forEach(seat -> this.level().addFreshEntity((Entity)seat));
    }

    public void onRemovedFromLevel() {
        Services.PLATFORM.onRemovedFromLevel((Entity)this);
        this.seats.forEach(Entity::discard);
    }

    @Override
    public Useable.UsageType getUsage() {
        return Useable.UsageType.CLIMB;
    }
}

