/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.projectile;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ru.magistu.siegemachines.entity.ModEntityTypes;
import ru.magistu.siegemachines.entity.projectile.Cannonball;
import ru.magistu.siegemachines.entity.projectile.GiantArrow;
import ru.magistu.siegemachines.entity.projectile.GiantStone;
import ru.magistu.siegemachines.entity.projectile.ProjectileFactory;
import ru.magistu.siegemachines.entity.projectile.Stone;
import ru.magistu.siegemachines.item.ModItems;

public class ProjectileBuilder<T extends Projectile> {
    public static final ProjectileBuilder<Stone> NONE = new ProjectileBuilder<Stone>(Items.AIR, (EntityType)ModEntityTypes.STONE.get(), (entitytype1, level, pos, shooter, engine, item1) -> new Stone((EntityType<Stone>)entitytype1, level, pos, shooter, engine));
    public static final ProjectileBuilder<?>[] NO_AMMO = new ProjectileBuilder[0];
    public static final ProjectileBuilder<?>[] GIANT_THROWING_AMMO = new ProjectileBuilder[]{new ProjectileBuilder<GiantStone>(Items.COBBLESTONE, (Item)ModItems.GIANT_STONE.get(), (EntityType)ModEntityTypes.GIANT_STONE.get(), (entitytype1, level, pos, shooter, engine, stack) -> new GiantStone((EntityType<GiantStone>)entitytype1, level, pos, shooter, engine))};
    public static final ProjectileBuilder<?>[] CANNON_AMMO = new ProjectileBuilder[]{new ProjectileBuilder<Cannonball>((Item)ModItems.CANNONBALL.get(), (EntityType)ModEntityTypes.CANNONBALL.get(), (entitytype1, level, pos, shooter, engine, stack) -> new Cannonball((EntityType<Cannonball>)entitytype1, level, pos, shooter, engine))};
    public static final ProjectileBuilder<?>[] THROWING_AMMO = new ProjectileBuilder[]{new ProjectileBuilder<Stone>(Items.COBBLESTONE, (Item)ModItems.STONE.get(), (EntityType)ModEntityTypes.STONE.get(), (entitytype1, level, pos, shooter, engine, item1) -> new Stone((EntityType<Stone>)entitytype1, level, pos, shooter, engine))};
    public static final ProjectileBuilder<?>[] BALLISTA_AMMO = new ProjectileBuilder[]{new ProjectileBuilder<GiantArrow>((Item)ModItems.GIANT_ARROW.get(), (EntityType)ModEntityTypes.GIANT_ARROW.get(), GiantArrow::new), new ProjectileBuilder<Arrow>(Items.ARROW, EntityType.ARROW, (entitytype, level, pos, shooter, engine, stack) -> {
        if (shooter.hasControllingPassenger()) {
            shooter = shooter.getControllingPassenger();
        }
        Arrow arrow = new Arrow(level, shooter, new ItemStack((ItemLike)Items.ARROW), null);
        arrow.setPos(pos.x, pos.y, pos.z);
        return arrow;
    })};
    public final Item item;
    public final Item projectilitem;
    public final EntityType<T> entitytype;
    public final ProjectileFactory<T> factory;

    public ProjectileBuilder(Item item, EntityType<T> entitytype, ProjectileFactory<T> factory) {
        this(item, item, entitytype, factory);
    }

    public ProjectileBuilder(Item item, Item projectilitem, EntityType<T> entitytype, ProjectileFactory<T> factory) {
        this.item = item;
        this.projectilitem = projectilitem;
        this.entitytype = entitytype;
        this.factory = factory;
    }

    public T build(Level level, Vec3 pos, LivingEntity entity, Entity engine) {
        return this.factory.create(this.entitytype, level, pos, entity, engine, new ItemStack((ItemLike)this.item));
    }
}

