/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.gui.machine.crosshair;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.gui.machine.crosshair.Crosshair;

public class ReloadingCrosshair
extends Crosshair {
    public int x = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2;
    public int y = Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2;

    public ReloadingCrosshair() {
        super(9, 9);
    }

    @Override
    public void render(GuiGraphics matrixstack, DeltaTracker ticks) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!player.isPassenger()) {
            return;
        }
        Entity entity = player.getVehicle();
        if (entity instanceof Machine) {
            Machine machine = (Machine)entity;
            int width = 11;
            int height = 11;
            int imagex = 0;
            int imagey = 0;
            int originx = (matrixstack.guiWidth() - width) / 2;
            int originy = (matrixstack.guiHeight() - height) / 2;
            int animationsize = 23;
            if (machine.getUseTicks() > 0) {
                imagey = height;
            } else if (machine.getDelayTicks() > 0) {
                int number = (int)((double)animationsize * ((double)((Integer)machine.type.specs.delaytime.get() - machine.getDelayTicks()) / (double)((Integer)machine.type.specs.delaytime.get()).intValue()));
                imagex = width;
                imagey = height * number;
            }
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CROSSHAIR_TEXTURES);
            matrixstack.blit(CROSSHAIR_TEXTURES, originx, originy, imagex, imagey, width, height);
            RenderSystem.backupProjectionMatrix();
        }
    }
}

