/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.plugin.rei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;
import ru.magistu.siegemachines.item.recipes.SiegeWorkbenchRecipe;
import ru.magistu.siegemachines.plugin.rei.SiegeWorkbenchCategory;

public class SiegeWorkbenchRecipeDisplay
implements Display {
    private final SiegeWorkbenchRecipe recipe;
    private final List<EntryIngredient> inputEntries;
    private final List<EntryIngredient> outputEntries;

    public SiegeWorkbenchRecipeDisplay(RecipeHolder<SiegeWorkbenchRecipe> recipe) {
        this.recipe = (SiegeWorkbenchRecipe)recipe.value();
        this.inputEntries = new ArrayList<EntryIngredient>();
        for (Ingredient ingredient : ((SiegeWorkbenchRecipe)recipe.value()).pattern.ingredients()) {
            this.inputEntries.add(EntryIngredients.ofIngredient((Ingredient)ingredient));
        }
        this.outputEntries = Collections.singletonList(EntryIngredients.of((ItemStack)((SiegeWorkbenchRecipe)recipe.value()).getResultItem(null)));
    }

    public SiegeWorkbenchRecipe getRecipe() {
        return this.recipe;
    }

    @NotNull
    public List<EntryIngredient> getInputEntries() {
        return this.inputEntries;
    }

    @NotNull
    public List<EntryIngredient> getOutputEntries() {
        return this.outputEntries;
    }

    @NotNull
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return SiegeWorkbenchCategory.ID;
    }
}

