/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ru.magistu.siegemachines.api.enitity.Useable;
import ru.magistu.siegemachines.client.ModSoundTypes;
import ru.magistu.siegemachines.entity.Explosive;
import ru.magistu.siegemachines.entity.Reloading;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.machine.MachineGeoEntity;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.projectile.ExplosiveBasedExplosionDamageCalculator;
import ru.magistu.siegemachines.entity.projectile.MissileExplosion;
import ru.magistu.siegemachines.network.ModNetwork;
import ru.magistu.siegemachines.network.S2CPacketMachineUse;
import ru.magistu.siegemachines.util.BaseAnimations;
import ru.magistu.siegemachines.util.CartesianGeometry;
import ru.magistu.siegemachines.util.CombatUtil;
import ru.magistu.siegemachines.util.HitUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BatteringRam
extends Machine
implements MachineGeoEntity,
Reloading,
Explosive {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int hittingticks = 0;
    private int wheelssoundticks = 10;
    public double lastwheelpitch;
    protected Entity lastUsedEntity;
    private final ExplosiveBasedExplosionDamageCalculator explosionDamageCalculator = new ExplosiveBasedExplosionDamageCalculator(this);
    public State state = State.RELOADING;
    private double wheelspitch = 0.0;

    public BatteringRam(EntityType<? extends Mob> entitytype, Level level) {
        super(entitytype, level, MachineType.BATTERING_RAM);
    }

    @Override
    public RawAnimation getUsingRawAnimation() {
        return BaseAnimations.HITTING_ANIM;
    }

    @Override
    public RawAnimation getReloadingAnimation() {
        return BaseAnimations.RELOADING_ANIM;
    }

    @Override
    public int getDelayTime() {
        return (Integer)this.f_19847_.specs.delaytime.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().m_5776_() && !this.m_20160_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7023_(Vec3 velocity) {
        if (this.m_6084_()) {
            if (this.m_20160_()) {
                LivingEntity livingentity = this.m_6688_();
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.m_7910_(0.04f);
                velocity = new Vec3(0.0, velocity.f_82480_, (double)f1);
            }
            super.m_7023_(velocity);
        }
    }

    @Override
    public void m_8119_() {
        LivingEntity passenger;
        this.lastwheelpitch = this.wheelspitch;
        this.wheelspitch += this.getWheelsSpeed();
        if (this.hittingticks != 0 && --this.hittingticks <= 0) {
            this.useRelease();
            this.hittingticks = 0;
        }
        if (this.m_9236_().m_5776_() && this.m_217005_() && this.getWheelsSpeed() > 0.0081 && this.wheelssoundticks-- <= 0 && Minecraft.m_91087_().f_91074_ == (passenger = this.m_6688_())) {
            Vec3 pos = this.m_20182_();
            this.m_9236_().m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)ModSoundTypes.RAM_WHEELS.get(), this.m_5720_(), 1.5f, 0.85f + this.m_9236_().f_46441_.m_188501_() * 0.3f, false);
            this.wheelssoundticks = 20;
        }
        super.m_8119_();
    }

    public double getLerpedWheelPitch(float partialTick) {
        return Mth.m_14139_((double)partialTick, (double)this.lastwheelpitch, (double)this.wheelspitch);
    }

    @Override
    public void use(LivingEntity entity) {
        if (this.deploymentticks > 0 && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_213846_((Component)Component.m_237110_((String)"siegemachines.wait", (Object[])new Object[]{Float.valueOf((float)this.deploymentticks / 20.0f)}).m_130940_(ChatFormatting.RED));
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            ModNetwork.sendPacketToAllInArea(new S2CPacketMachineUse(this.m_19879_()), this.m_20183_(), 16384);
        }
        this.lastUsedEntity = entity;
        if (this.getDelayTicks() <= 0 && this.getUseTicks() <= 0 && this.hittingticks <= 0) {
            this.usesoundplayer.run();
            this.state = State.HITTING;
            this.setUseTicks(this.f_19847_.usetime);
            this.hittingticks = this.f_19847_.usereleasetime;
        }
    }

    public void ramHit(BlockPos blockpos) {
        if (!this.m_9236_().m_5776_()) {
            int x = blockpos.m_123341_();
            int y = blockpos.m_123342_();
            int z = blockpos.m_123343_();
            BatteringRam source = this.lastUsedEntity == null ? this : this.lastUsedEntity;
            MissileExplosion explosion = new MissileExplosion(this.m_9236_(), (Entity)source, this.m_9236_().m_269111_().m_269036_((Entity)this, (Entity)source), this.explosionDamageCalculator, x, y, z, 2.0f, false, Explosion.BlockInteraction.DESTROY);
            explosion.m_46061_();
            explosion.m_46075_(false);
        }
    }

    @Override
    public float getBlockResistance(Explosion explosion, BlockGetter level, BlockPos pos, BlockState blockState, FluidState fluidState, float resistance) {
        return resistance;
    }

    @Override
    public double getExplosionDamageMultiplier() {
        return 1.0;
    }

    @Override
    public boolean shouldDamageEntity(Explosion explosion, Entity victim) {
        return CombatUtil.canHurt(this.lastUsedEntity, victim);
    }

    @Override
    public boolean shouldBlockDestroy(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, float power) {
        return (double)pos.m_123342_() > this.m_20186_() - 0.5;
    }

    @Override
    public void useRelease() {
        if (this.deploymentticks > 0) {
            Entity entity = this.lastUsedEntity;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_213846_((Component)Component.m_237110_((String)"siegemachines.wait", (Object[])new Object[]{Float.valueOf((float)this.deploymentticks / 20.0f)}).m_130940_(ChatFormatting.RED));
            }
            return;
        }
        this.usereleasesoundplayer.run();
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)66);
            BlockPos blockpos = BlockPos.m_274446_((Position)this.getHitPos());
            this.ramHit(blockpos);
        }
    }

    private Vec3 getHitPos() {
        Vec3 delta;
        double pitch = (double)this.getTurretPitch() * Math.PI / 180.0;
        double yaw = (double)(this.m_5675_(0.5f) + this.getTurretYaw()) * Math.PI / 180.0;
        Vec3 pos = this.m_20182_().m_82549_(CartesianGeometry.applyRotations(this.f_19847_.turretpivot, 0.0, yaw));
        HitResult hit = HitUtil.getHitResult(pos, (Entity)this, e -> e.m_20202_() != this, delta = CartesianGeometry.applyRotations(this.f_19847_.turretvector, pitch, yaw), this.m_9236_(), 0.0f, ClipContext.Block.COLLIDER);
        if (hit.m_6662_() != HitResult.Type.MISS) {
            return hit.m_82450_();
        }
        return pos.m_82549_(delta);
    }

    public double getWheelsSpeed() {
        if (this.m_20096_()) {
            return this.m_20252_(5.0f).m_82542_(1.0, 0.0, 1.0).m_82526_(this.m_20184_());
        }
        return 0.0;
    }

    public void m_5997_(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
    }

    @Override
    public Useable.UsageType getUsage() {
        return Useable.UsageType.RAM;
    }

    public static enum State {
        HITTING,
        RELOADING;

    }
}

