/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import ru.magistu.siegemachines.api.enitity.Shootable;
import ru.magistu.siegemachines.entity.Reloading;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.projectile.ProjectileBuilder;
import ru.magistu.siegemachines.network.ModNetwork;
import ru.magistu.siegemachines.network.S2CPacketMachineUse;
import ru.magistu.siegemachines.util.CartesianGeometry;

public abstract class ShootingMachine
extends Machine
implements Shootable,
Reloading {
    public int shootingticks = 0;
    protected LivingEntity lastUsedEntity = null;

    protected ShootingMachine(EntityType<? extends Mob> entitytype, Level level, MachineType type) {
        super(entitytype, level, type);
    }

    public abstract void startShooting(LivingEntity var1);

    public void shoot() {
        if (this.f_19847_.ammo.length == 0) {
            return;
        }
        ProjectileBuilder<? extends Projectile> projectilebuilder = this.getProjectileBuilder();
        if (projectilebuilder.equals(ProjectileBuilder.NONE)) {
            LivingEntity passenger = this.m_6688_();
            if (!this.m_9236_().m_5776_() && passenger instanceof Player) {
                passenger.m_213846_((Component)Component.m_237115_((String)"siegemachines.no_ammo").m_130940_(ChatFormatting.RED));
            }
            return;
        }
        ItemStack itemstack = this.inventory.removeItemType(projectilebuilder.item, 1);
        if (!itemstack.m_41619_() && !this.m_9236_().m_5776_()) {
            Vec3 shotpos = this.getShotPos();
            ShootingMachine owner = this.lastUsedEntity == null ? this : this.lastUsedEntity;
            Projectile projectile = projectilebuilder.build(this.m_9236_(), new Vector3d(shotpos.f_82479_, shotpos.f_82480_, shotpos.f_82481_), (LivingEntity)owner, (Entity)this);
            float pitch = this.getTurretPitch();
            float yaw = this.getGlobalTurretYaw();
            projectile.m_37251_((Entity)this, pitch, yaw, 0.0f, (float)((Double)this.f_19847_.specs.projectilespeed.get()).doubleValue(), (float)((Double)this.f_19847_.specs.inaccuracy.get()).doubleValue());
            this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    @Override
    public void use(LivingEntity entity) {
        if (!this.m_9236_().m_5776_()) {
            ModNetwork.sendPacketToAllInArea(new S2CPacketMachineUse(this.m_19879_()), this.m_20183_(), 16384);
        }
        this.lastUsedEntity = entity;
        this.startShooting(entity);
    }

    @Override
    public void useRelease() {
        if (this.deploymentticks > 0) {
            LivingEntity livingEntity = this.m_6688_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_213846_((Component)Component.m_237110_((String)"siegemachines.wait", (Object[])new Object[]{Float.valueOf((float)this.deploymentticks / 20.0f)}).m_130940_(ChatFormatting.RED));
            }
            return;
        }
        this.usereleasesoundplayer.run();
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)66);
        }
        this.shoot();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isValidAmmo(stack)) {
            if (!this.hasAmmo()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                ItemStack stack1 = stack.m_41777_();
                stack1.m_41764_(1);
                this.inventory.addItem(stack1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_8119_() {
        if (this.shootingticks > 0 && --this.shootingticks <= 0) {
            this.useRelease();
            this.shootingticks = 0;
        }
        super.m_8119_();
    }

    @Override
    public Vec3 getShotPos() {
        double pitch = (double)this.getTurretPitch() * Math.PI / 180.0;
        double yaw = (double)(this.m_5675_(1.0f) + this.getTurretYaw()) * Math.PI / 180.0;
        return this.m_20182_().m_82549_(CartesianGeometry.applyRotations(this.f_19847_.turretpivot, 0.0, yaw).m_82549_(CartesianGeometry.applyRotations(this.f_19847_.turretvector, pitch, yaw)));
    }

    @Override
    public Vec3 getShotView() {
        double pitch = (double)this.getTurretPitch() * Math.PI / 180.0;
        double yaw = (double)this.getGlobalTurretYaw() * Math.PI / 180.0;
        double d0 = -Math.sin(yaw) * Math.cos(pitch);
        double d1 = -Math.sin(pitch);
        double d2 = Math.cos(yaw) * Math.cos(pitch);
        return new Vec3(d0, d1, d2).m_82541_();
    }

    protected void blowParticles(ParticleOptions particle, double speed, int amount) {
        for (int i = 0; i < amount; ++i) {
            Vec3 pos = this.getShotPos();
            Vec3 inaccuracy = new Vec3(new Random().nextGaussian() * 0.2, new Random().nextGaussian() * 0.2, new Random().nextGaussian() * 0.2);
            Vec3 velocity = this.getShotView().m_82549_(inaccuracy).m_82490_(speed);
            this.m_9236_().m_7106_(particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    @Override
    public boolean isValidAmmo(ItemStack stack) {
        return this.isValidAmmo(stack.m_41720_());
    }

    public boolean isValidAmmo(Item entry) {
        return Arrays.stream(this.f_19847_.ammo).anyMatch(builder -> builder.item.equals(entry));
    }

    public ItemStack getAmmo() {
        return this.inventory.getItems().stream().filter(this::isValidAmmo).findFirst().orElse(ItemStack.f_41583_);
    }

    @Override
    public List<Item> getValidAmmo() {
        return Arrays.stream(this.f_19847_.ammo).map(builder -> builder.item).collect(Collectors.toList());
    }

    @Override
    public boolean hasAmmo() {
        return this.inventory.getItems().stream().anyMatch(this::isValidAmmo);
    }

    @Override
    public boolean reload(ItemStack stack) {
        if (this.isValidAmmo(stack)) {
            return !this.inventory.addItem(stack).m_41619_();
        }
        return false;
    }

    @Override
    public float getProjectileInitSpeed() {
        return ((Double)this.f_19847_.specs.projectilespeed.get()).floatValue();
    }

    public ProjectileBuilder<? extends Projectile> getProjectileBuilder() {
        ItemStack ammo = this.getAmmo();
        if (ammo.equals(ItemStack.f_41583_)) {
            return ProjectileBuilder.NONE;
        }
        return Arrays.stream(this.f_19847_.ammo).filter(builder -> builder.item.equals(ammo.m_41720_())).findFirst().orElse(ProjectileBuilder.NONE);
    }
}

