/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import ru.magistu.siegemachines.api.enitity.Useable;
import ru.magistu.siegemachines.entity.machine.LadderSeat;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.util.CartesianGeometry;
import ru.magistu.siegemachines.util.HitUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SiegeLadder
extends Machine
implements GeoEntity {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Vec3 CLIMB_VECTOR = new Vec3(0.0, 130.0, 130.0).m_82490_(0.0625);
    private static final Vec3 CLIMB_PIVOT_1 = new Vec3(-8.0, 0.0, -37.0).m_82490_(0.0625);
    private static final Vec3 CLIMB_PIVOT_2 = new Vec3(8.0, 0.0, -37.0).m_82490_(0.0625);
    private static final int NUMBER_OF_SEATS = 16;
    private final List<LadderSeat> leftseats = Stream.generate(() -> new LadderSeat(this)).limit(8L).collect(Collectors.toList());
    private final List<LadderSeat> rightseats = Stream.generate(() -> new LadderSeat(this)).limit(8L).collect(Collectors.toList());
    public final List<LadderSeat> seats = Stream.of(this.leftseats, this.rightseats).flatMap(Collection::stream).collect(Collectors.toList());
    private double lastwheelpitch;
    private double wheelspitch = 0.0;

    public SiegeLadder(EntityType<? extends Mob> entitytype, Level level) {
        super(entitytype, level, MachineType.SIEGE_LADDER);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_9236_().m_5776_() || player.m_20159_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_20160_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        LadderSeat seat = this.getFreeSeat((LivingEntity)player);
        if (seat != null) {
            player.m_20329_((Entity)seat);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_7023_(Vec3 velocity) {
        if (this.m_6084_()) {
            if (this.m_217005_()) {
                LivingEntity livingentity = this.m_6688_();
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.m_7910_(0.04f);
                velocity = new Vec3(0.0, velocity.f_82480_, (double)f1);
            }
            super.m_7023_(velocity);
        }
    }

    @Override
    public void m_8119_() {
        this.lastwheelpitch = this.wheelspitch;
        this.wheelspitch += this.getWheelsSpeed();
        this.seatsTick();
        super.m_8119_();
    }

    public double getLerpedWheelPitch(float partialTick) {
        return Mth.m_14139_((double)partialTick, (double)this.lastwheelpitch, (double)this.wheelspitch);
    }

    public void seatsTick() {
        this.leftseats.forEach(seat -> this.updateSeatPosition((LadderSeat)((Object)seat), true));
        this.rightseats.forEach(seat -> this.updateSeatPosition((LadderSeat)((Object)seat), false));
    }

    @Override
    protected boolean canDropAsItem() {
        return super.canDropAsItem() && this.seats.stream().noneMatch(Entity::m_20160_);
    }

    public void updateSeatPosition(LadderSeat seat, boolean left) {
        HitResult hit;
        double yaw = (double)this.m_146908_() * Math.PI / 180.0;
        float highness = seat.climb();
        Vec3 origin = this.getSeatOrigin(left, yaw);
        Vec3 pos = origin.m_82549_(CartesianGeometry.applyRotations(CLIMB_VECTOR.m_82490_((double)highness), 0.0, yaw));
        Optional freepos = this.m_9236_().m_151418_((Entity)seat, Shapes.m_83064_((AABB)AABB.m_165882_((Vec3)pos, (double)0.1, (double)0.1, (double)0.1)), pos, 0.0, 0.0, 0.0);
        if (freepos.isPresent() && pos.m_82554_((Vec3)freepos.get()) < 0.5) {
            seat.setHighness(highness);
            pos = (Vec3)freepos.get();
        }
        if (seat.m_20160_() && (hit = HitUtil.getBlockHitResult(origin, pos.m_82546_(origin), this.m_9236_(), ClipContext.Block.COLLIDER)).m_6662_() != HitResult.Type.MISS) {
            highness = (float)(hit.m_82450_().m_82546_(origin).m_82553_() / CLIMB_VECTOR.m_82553_());
            seat.setHighness(highness);
            pos = hit.m_82450_();
        }
        seat.m_20219_(pos);
    }

    private Vec3 getSeatOrigin(boolean left, double yaw) {
        return this.m_20182_().m_82549_(CartesianGeometry.applyRotations(left ? CLIMB_PIVOT_1 : CLIMB_PIVOT_2, 0.0, yaw));
    }

    public void m_142687_(Entity.RemovalReason reason) {
        for (LadderSeat seat : this.seats) {
            seat.m_146870_();
        }
        super.m_142687_(reason);
    }

    @Override
    public void use(LivingEntity entity) {
        LadderSeat seat;
        if (this.m_6688_() == entity && (seat = this.getFreeSeat(entity)) != null) {
            entity.m_20329_((Entity)seat);
        }
    }

    @Override
    public void useRelease() {
    }

    public double getWheelsSpeed() {
        if (this.m_20096_()) {
            return this.m_20252_(5.0f).m_82542_(1.0, 0.0, 1.0).m_82526_(this.m_20184_());
        }
        return 0.0;
    }

    @Nullable
    protected LadderSeat getFreeSeat(LivingEntity entity) {
        long l2;
        AtomicReference<Object> left = new AtomicReference<Object>(null);
        AtomicReference<Object> right = new AtomicReference<Object>(null);
        long l1 = this.leftseats.stream().filter(seat -> {
            if (seat.m_20160_()) {
                return true;
            }
            left.set(seat);
            return false;
        }).count();
        if (l1 < (l2 = this.rightseats.stream().filter(seat -> {
            if (seat.m_20160_()) {
                return true;
            }
            right.set(seat);
            return false;
        }).count())) {
            return left.get();
        }
        if (l1 == l2 && entity != null) {
            Vec3 view = this.m_20252_(0.0f);
            return entity.m_20182_().m_82546_(this.m_20182_()).m_82526_(new Vec3(view.f_82481_, 0.0, -view.f_82479_).m_82541_()) > 0.0 ? (LadderSeat)right.get() : (LadderSeat)left.get();
        }
        return right.get();
    }

    public void m_7334_(Entity entity) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    public void onAddedToWorld() {
        this.seats.forEach(seat -> this.m_9236_().m_7967_((Entity)seat));
        super.onAddedToWorld();
    }

    public void onRemovedFromWorld() {
        this.seats.forEach(Entity::m_146870_);
        super.onRemovedFromWorld();
    }

    @Override
    public Useable.UsageType getUsage() {
        return Useable.UsageType.CLIMB;
    }

    @Override
    public AABB m_6921_() {
        AABB box = this.m_20191_();
        return box.m_82377_(1.5 * box.m_82362_(), 1.5 * box.m_82376_(), 1.5 * box.m_82385_());
    }
}

