/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.projectile;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Vector3d;
import ru.magistu.siegemachines.entity.Explosive;
import ru.magistu.siegemachines.entity.projectile.ExplosiveBasedExplosionDamageCalculator;
import ru.magistu.siegemachines.entity.projectile.FlightType;
import ru.magistu.siegemachines.entity.projectile.MissileExplosion;
import ru.magistu.siegemachines.entity.projectile.MissileType;
import ru.magistu.siegemachines.util.CombatUtil;

public abstract class Missile
extends ThrowableItemProjectile
implements Explosive {
    public MissileType f_19847_ = MissileType.STONE;
    protected Entity engine = null;
    private final ExplosiveBasedExplosionDamageCalculator explosionDamageCalculator = new ExplosiveBasedExplosionDamageCalculator(this);
    private static final Map<Block, Block> BLOCK_CRACKING_MAP = Map.of(Blocks.f_50222_, Blocks.f_50224_, Blocks.f_50176_, Blocks.f_50224_, Blocks.f_152589_, Blocks.f_152594_, Blocks.f_152559_, Blocks.f_152595_, Blocks.f_50197_, Blocks.f_50713_, Blocks.f_50069_, Blocks.f_50652_, Blocks.f_152550_, Blocks.f_152551_, Blocks.f_50440_, Blocks.f_50493_);
    protected static final int MISSILE_EXPLOSION = 66;

    public Missile(EntityType<? extends Missile> entitytype, Level level) {
        super(entitytype, level);
    }

    public Missile(EntityType<? extends Missile> entitytype, Level level, Vector3d pos, LivingEntity shooter, Entity engine, MissileType type) {
        super(entitytype, shooter.m_6688_() != null ? shooter.m_6688_() : shooter, level);
        this.f_19847_ = type;
        this.engine = engine;
        this.m_6034_(pos.x, pos.y, pos.z);
    }

    public void m_6532_(HitResult hit) {
        switch (hit.m_6662_()) {
            case ENTITY: {
                this.handleEntityHit((EntityHitResult)hit);
                break;
            }
            case BLOCK: {
                this.handleBlockHit((BlockHitResult)hit);
                break;
            }
            case MISS: {
                this.handleMiss();
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    protected void handleEntityHit(EntityHitResult entityHit) {
        Vec3 pos = entityHit.m_82450_();
        Entity victim = entityHit.m_82443_();
        float damage = (float)((Double)this.f_19847_.specs.mass.get() * this.m_20184_().m_82553_() * 0.1);
        DamageSource damageSource = this.m_269291_().m_269390_((Entity)this, this.getIndirectSourceEntityInternal());
        if (victim instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)victim;
            float armor = CombatRules.m_19272_((float)damage, (float)livingEntity.m_21230_(), (float)((float)livingEntity.m_21051_(Attributes.f_22285_).m_22135_()));
            damage += ((Double)this.f_19847_.specs.armorpiercing.get()).floatValue() * (damage - armor);
        }
        if (!this.m_9236_().m_5776_() && ((Boolean)this.f_19847_.specs.explosive.get()).booleanValue()) {
            this.explode(pos.m_82546_(this.m_20184_().m_82541_().m_82490_(0.5)), Explosion.BlockInteraction.DESTROY);
        }
        if (this.canHurt(victim)) {
            victim.m_6469_(damageSource, damage);
            this.applyKnockback(victim);
        }
    }

    private void applyKnockback(Entity entity) {
        double knockback;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            knockback = ProtectionEnchantment.m_45135_((LivingEntity)livingentity, (double)((Double)this.f_19847_.specs.knockback.get()));
        } else {
            knockback = (Double)this.f_19847_.specs.knockback.get();
        }
        Vec3 knockbackVec = this.m_20184_().m_82541_().m_82490_(knockback);
        if (knockbackVec.m_82556_() > 0.0) {
            entity.m_5997_(knockbackVec.f_82479_, knockbackVec.f_82480_, knockbackVec.f_82481_);
        }
    }

    protected void handleBlockHit(BlockHitResult blockHit) {
        Vec3 pos = blockHit.m_82450_();
        if (!this.m_9236_().m_5776_() && ((Boolean)this.f_19847_.specs.explosive.get()).booleanValue()) {
            Explosion.BlockInteraction interaction = this.getExplosionBlockInteraction();
            this.explode(pos.m_231075_(blockHit.m_82434_(), 0.5), interaction);
        }
    }

    private Explosion.BlockInteraction getExplosionBlockInteraction() {
        if (!ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this.m_19749_())) {
            return Explosion.BlockInteraction.KEEP;
        }
        return this.m_9236_().m_46469_().m_46207_(GameRules.f_254692_) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }

    private void crackBlocks(BlockPos origin) {
        int r = 0;
        while ((double)r < 1.5 * (Double)this.f_19847_.specs.explosionpower.get()) {
            for (int a = 0; a < 8; ++a) {
                for (int b = 0; b < 8; ++b) {
                    float phi = (float)((double)a * Math.PI / 4.0);
                    float theta = (float)((double)b * Math.PI / 4.0);
                    int dx = (int)((double)r * Math.sin(theta) * Math.cos(phi));
                    int dy = (int)((double)r * Math.cos(theta));
                    int dz = (int)((double)r * Math.sin(theta) * Math.sin(phi));
                    BlockPos pos2 = origin.m_7918_(dx, dy, dz);
                    Block crackedBlock = BLOCK_CRACKING_MAP.get(this.m_9236_().m_8055_(pos2).m_60734_());
                    if (crackedBlock == null) continue;
                    this.m_9236_().m_46597_(pos2, crackedBlock.m_49966_());
                }
            }
            ++r;
        }
    }

    protected void handleMiss() {
    }

    public boolean canHurt(Entity victim) {
        return CombatUtil.canHurt(this.m_19749_(), victim);
    }

    public void m_8119_() {
        if (this.f_19847_.flighttype == FlightType.SPINNING) {
            this.m_146926_(this.m_146909_() + 0.5f);
        }
        super.m_8119_();
    }

    public Explosion explode(Vec3 pos, Explosion.BlockInteraction mode) {
        Entity source = this.m_19749_();
        float size = this.getExplosionPower();
        Entity indirectSource = this.getIndirectSourceEntityInternal();
        double x = pos.f_82479_;
        double y = pos.f_82480_;
        double z = pos.f_82481_;
        boolean fired = (Boolean)this.f_19847_.specs.fired.get();
        MissileExplosion explosion = new MissileExplosion(this.m_9236_(), source, this.m_269291_().m_269036_((Entity)this, indirectSource), this.explosionDamageCalculator, x, y, z, size, fired, mode);
        if (ForgeEventFactory.onExplosionStart((Level)this.m_9236_(), (Explosion)explosion)) {
            return explosion;
        }
        this.crackBlocks(new BlockPos((int)x, (int)y, (int)z));
        explosion.m_46061_();
        explosion.m_46075_(true);
        this.m_9236_().m_7605_((Entity)this, (byte)66);
        return explosion;
    }

    protected float getExplosionPower() {
        float defaultPower = ((Double)this.f_19847_.specs.explosionpower.get()).floatValue();
        float speed = (float)this.m_20184_().m_82553_();
        float power = (float)((double)(defaultPower * 0.3f) + Math.log1p(speed) * (double)defaultPower * 0.5);
        return Mth.m_14036_((float)power, (float)(defaultPower * 0.7f), (float)(defaultPower * 1.5f));
    }

    @Override
    public float getBlockResistance(Explosion explosion, BlockGetter level, BlockPos pos, BlockState blockState, FluidState fluidState, float resistance) {
        if (BLOCK_CRACKING_MAP.containsValue(level.m_8055_(pos).m_60734_())) {
            resistance *= 0.83f;
        }
        float speed = (float)this.m_20184_().m_82553_();
        float power = (float)(0.5 + Math.log1p(speed) * 0.5);
        return resistance / Mth.m_14036_((float)power, (float)0.7f, (float)1.5f);
    }

    @Override
    public double getExplosionDamageMultiplier() {
        double defaultMultiplier = (Double)this.f_19847_.specs.explosiondamagemultiplier.get();
        double speed = this.m_20184_().m_82553_();
        double multiplier = defaultMultiplier * 0.33 + Math.log1p(speed) * defaultMultiplier * 0.5;
        return Mth.m_14008_((double)multiplier, (double)(defaultMultiplier * 0.7), (double)(defaultMultiplier * 1.5));
    }

    @Override
    public boolean shouldDamageEntity(Explosion explosion, Entity victim) {
        return CombatUtil.canHurt(this.m_19749_(), victim);
    }

    @Override
    public boolean shouldBlockDestroy(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, float power) {
        return true;
    }

    @Nullable
    private Entity getIndirectSourceEntityInternal() {
        return this.m_19749_() != null ? this.m_19749_() : this.engine;
    }

    public void m_7822_(byte id) {
        if (id == 66 && this.m_9236_().m_5776_()) {
            this.explode(this.m_20182_(), Explosion.BlockInteraction.KEEP);
        } else {
            super.m_7822_(id);
        }
    }
}

