/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.item;

import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import ru.magistu.siegemachines.client.KeyBindings;
import ru.magistu.siegemachines.client.renderer.MachineItemGeoRenderer;
import ru.magistu.siegemachines.config.SpecsConfig;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.projectile.ProjectileBuilder;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MachineItem<T extends Machine>
extends Item
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<EntityType<T>> entitytype;
    private final Supplier<MachineType> machinetype;

    public MachineItem(Item.Properties prop, Supplier<EntityType<T>> entitytype, Supplier<MachineType> machinetype) {
        super(prop.m_41487_(1));
        this.entitytype = entitytype;
        this.machinetype = machinetype;
    }

    public MachineItemGeoRenderer<T> getRenderer() {
        throw new NotImplementedException(MessageFormat.format("No renderer registered for {0} item", this.entitytype.get().toString()));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        ProjectileBuilder<?>[] ammo;
        if (KeyBindings.getUseKey(this.machinetype.get()) != null) {
            tooltip.add((Component)Component.m_237110_((String)"siegemachines.usage", (Object[])new Object[]{KeyBindings.getUseKey(this.machinetype.get()).getKey().m_84875_()}).m_130940_(ChatFormatting.BLUE));
        }
        if ((ammo = this.machinetype.get().ammo).length > 0) {
            tooltip.add((Component)Component.m_237115_((String)"siegemachines.ammo").m_130940_(ChatFormatting.BLUE));
            for (ProjectileBuilder<?> builder : ammo) {
                if (this.machinetype.get().usesgunpowder) {
                    tooltip.add((Component)Component.m_237115_((String)"siegemachines.uses_gunpowder").m_130940_(ChatFormatting.BLUE));
                }
                tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)builder.item.m_5524_())).m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return MachineItem.this.getRenderer();
            }
        });
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity tileentity;
        Level world = context.m_43725_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.m_43722_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockstate = world.m_8055_(blockpos);
        CompoundTag data = itemstack.m_41783_();
        if (blockstate.m_60713_(Blocks.f_50085_) && (tileentity = world.m_7702_(blockpos)) instanceof SpawnerBlockEntity) {
            BaseSpawner abstractspawner = ((SpawnerBlockEntity)tileentity).m_59801_();
            EntityType<T> entitytype1 = this.getType(data);
            abstractspawner.m_253197_(entitytype1, world, world.f_46441_, blockpos);
            tileentity.m_6596_();
            world.m_7260_(blockpos, blockstate, blockstate, 3);
            itemstack.m_41774_(1);
            return InteractionResult.CONSUME;
        }
        BlockPos blockpos2 = blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
        EntityType<T> entitytype = this.getType(data);
        Machine machine = this.spawn(entitytype, (ServerLevel)world, itemstack, context.m_43723_(), blockpos2, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos2) && direction == Direction.UP, context.m_7074_());
        if (machine != null) {
            if (data != null) {
                machine.m_7378_(data.m_6426_());
            }
            machine.applyAttributeSpecs();
            machine.setPreventPickupTicks((Integer)SpecsConfig.PREVENT_PICKUP_COOLDOWN.get());
            machine.setDeploymentTicks((Integer)SpecsConfig.DEPLOYMENT_SICKNESS_COOLDOWN.get());
            itemstack.m_41774_(1);
        }
        return InteractionResult.CONSUME;
    }

    protected static double getYOffset(LevelReader reader, BlockPos pos, boolean bl, AABB aabb) {
        AABB axisalignedbb = new AABB(pos);
        if (bl) {
            axisalignedbb = axisalignedbb.m_82363_(0.0, -1.0, 0.0);
        }
        Iterable iterable = reader.m_186431_(null, axisalignedbb);
        return 1.0 + Shapes.m_193135_((Direction.Axis)Direction.Axis.Y, (AABB)aabb, (Iterable)iterable, (double)(bl ? -2.0 : -1.0));
    }

    @Nullable
    public Machine spawn(EntityType<T> entitytype, ServerLevel level, @Nullable ItemStack stack, @Nullable Player player, BlockPos pos, MobSpawnType type, boolean bl, boolean bl2, float yaw) {
        return this.spawn(entitytype, level, stack == null ? null : stack.m_41783_(), stack != null && stack.m_41788_() ? stack.m_41786_() : null, player, pos, type, bl, bl2, yaw);
    }

    @Nullable
    private Machine spawn(EntityType<T> entitytype, ServerLevel level, @Nullable CompoundTag nbt, @Nullable Component component, @Nullable Player player, BlockPos pos, MobSpawnType type, boolean bl, boolean bl2, float yaw) {
        Machine machine = this.create(entitytype, level, nbt, component, player, pos, type, bl, bl2, yaw);
        if (machine != null) {
            if (!ForgeEventFactory.checkSpawnPosition((Mob)machine, (ServerLevelAccessor)level, (MobSpawnType)type)) {
                return null;
            }
            level.m_47205_((Entity)machine);
        }
        return machine;
    }

    @Nullable
    private Machine create(EntityType<T> entitytype, ServerLevel level, @Nullable CompoundTag nbt, @Nullable Component component, @Nullable Player player, BlockPos pos, MobSpawnType type, boolean bl, boolean bl2, float yaw) {
        double d0;
        Machine machine = (Machine)entitytype.m_20615_((Level)level);
        if (machine == null) {
            return null;
        }
        if (bl) {
            machine.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
            d0 = MachineItem.getYOffset((LevelReader)level, pos, bl2, machine.m_20191_());
        } else {
            d0 = 0.0;
        }
        EntityType.m_20620_((Level)level, (Player)player, (Entity)machine, (CompoundTag)nbt);
        if (component != null) {
            machine.m_6593_(component);
        }
        machine.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + d0, (double)pos.m_123343_() + 0.5, Mth.m_14177_((float)yaw), 0.0f);
        machine.f_20885_ = machine.m_146908_();
        machine.f_20883_ = machine.m_146908_();
        machine.m_6518_((ServerLevelAccessor)level, level.m_6436_(machine.m_20183_()), type, null, nbt);
        machine.m_8032_();
        return machine;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockHitResult raytraceresult = MachineItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        BlockPos blockpos = raytraceresult.m_82425_();
        if (level.m_7966_(player, blockpos) && player.m_36204_(blockpos, raytraceresult.m_82434_(), itemstack)) {
            CompoundTag data = itemstack.m_41783_();
            EntityType<T> entitytype = this.getType(data);
            Machine machine = this.spawn(entitytype, (ServerLevel)level, itemstack, player, blockpos, MobSpawnType.SPAWN_EGG, false, false, player.m_146908_());
            if (machine != null) {
                if (data != null) {
                    machine.m_7378_(data.m_6426_());
                }
                machine.setPreventPickupTicks((Integer)SpecsConfig.PREVENT_PICKUP_COOLDOWN.get());
                machine.setDeploymentTicks((Integer)SpecsConfig.DEPLOYMENT_SICKNESS_COOLDOWN.get());
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19096_((Object)itemstack);
            }
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    private EntityType<T> getType(@Nullable CompoundTag nbt) {
        EntityType<T> defaulttype = this.entitytype.get();
        if (nbt != null && nbt.m_128425_("id", 8)) {
            return EntityType.m_20632_((String)nbt.m_128461_("id")).orElse(defaulttype);
        }
        return defaulttype;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

