/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.item.recipes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.jetbrains.annotations.NotNull;
import ru.magistu.siegemachines.block.ModBlocks;
import ru.magistu.siegemachines.item.recipes.CountIngredient;

public class SiegeWorkbenchRecipe
implements IShapedRecipe<CraftingContainer> {
    static ResourceLocation TYPE_ID = new ResourceLocation("siegemachines", "siege_workbench");
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    private final ResourceLocation id;
    private final ItemStack result;
    private final List<CountIngredient> recipeitems;
    final int width;
    final int height;

    public SiegeWorkbenchRecipe(ResourceLocation id, int width, int height, List<CountIngredient> recipeitems, ItemStack result) {
        this.id = id;
        this.width = width;
        this.height = height;
        this.recipeitems = recipeitems;
        this.result = result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    @NotNull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.SIEGE_WORKBENCH.get());
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public List<CountIngredient> getRecipeItems() {
        return this.recipeitems;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        for (CountIngredient ingredient : this.recipeitems) {
            list.add((Object)ingredient.get());
        }
        return list;
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        for (int i = 0; i <= container.m_39347_() - this.width; ++i) {
            for (int j = 0; j <= container.m_39346_() - this.height; ++j) {
                if (this.matches(container, i, j, true)) {
                    return this.getRemainingItems(container, i, j, true);
                }
                if (!this.matches(container, i, j, false)) continue;
                return this.getRemainingItems(container, i, j, true);
            }
        }
        return NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
    }

    private NonNullList<ItemStack> getRemainingItems(CraftingContainer container, int width, int height, boolean mirrored) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < container.m_39347_(); ++i) {
            for (int j = 0; j < container.m_39346_(); ++j) {
                int k = i - width;
                int l = j - height;
                CountIngredient ingredient = CountIngredient.of(Ingredient.f_43901_);
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = mirrored ? this.recipeitems.get(this.width - k - 1 + l * this.width) : this.recipeitems.get(k + l * this.width);
                }
                int index = i + j * container.m_39347_();
                ItemStack stack = container.m_8020_(index);
                stack.m_41764_(ingredient.getCount());
                nonnulllist.set(index, (Object)stack);
            }
        }
        return nonnulllist;
    }

    public boolean matches(CraftingContainer container, Level level) {
        for (int i = 0; i <= container.m_39347_() - this.width; ++i) {
            for (int j = 0; j <= container.m_39346_() - this.height; ++j) {
                if (this.matches(container, i, j, true)) {
                    return true;
                }
                if (!this.matches(container, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer container, int width, int height, boolean mirrored) {
        for (int i = 0; i < container.m_39347_(); ++i) {
            for (int j = 0; j < container.m_39346_(); ++j) {
                int k = i - width;
                int l = j - height;
                CountIngredient ingredient = CountIngredient.of(Ingredient.f_43901_);
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = mirrored ? this.recipeitems.get(this.width - k - 1 + l * this.width) : this.recipeitems.get(k + l * this.width);
                }
                if (ingredient.test(container.m_8020_(i + j * container.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public int getWidth() {
        return this.width;
    }

    public int getRecipeWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.height;
    }

    public int getRecipeHeight() {
        return this.getHeight();
    }

    static NonNullList<CountIngredient> dissolvePattern(String[] pattern, Map<String, CountIngredient> keys, int patternwidth, int patternHeight) {
        NonNullList list = NonNullList.m_122780_((int)(patternwidth * patternHeight), (Object)CountIngredient.of(Ingredient.f_43901_));
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                CountIngredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                list.set(j + patternwidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return list;
    }

    @VisibleForTesting
    static String[] shrink(String ... toshrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toshrink.length; ++i1) {
            String s = toshrink[i1];
            i = Math.min(i, SiegeWorkbenchRecipe.firstNonSpace(s));
            int j1 = SiegeWorkbenchRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toshrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toshrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toshrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> list = this.m_7527_();
        return list.isEmpty() || list.stream().filter(ingredient -> !ingredient.m_43947_()).anyMatch(ForgeHooks::hasNoElements);
    }

    private static int firstNonSpace(String entry) {
        int i;
        for (i = 0; i < entry.length() && entry.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String entry) {
        int i;
        for (i = entry.length() - 1; i >= 0 && entry.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] patternFromJson(JsonArray patternarray) {
        String[] astring = new String[patternarray.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)patternarray.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    static Map<String, CountIngredient> keyFromJson(JsonObject keyentry) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : keyentry.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), CountIngredient.fromJson(((JsonElement)entry.getValue()).getAsJsonObject()));
        }
        map.put(" ", CountIngredient.of(Ingredient.f_43901_));
        return map;
    }

    public static ItemStack itemStackFromJson(JsonObject stackobject) {
        return CraftingHelper.getItemStack((JsonObject)stackobject, (boolean)true, (boolean)true);
    }

    public static class Serializer
    implements RecipeSerializer<SiegeWorkbenchRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("siegemachines", "siege_workbench");

        public SiegeWorkbenchRecipe fromJson(ResourceLocation recipeid, JsonObject json) {
            Map<String, CountIngredient> map = SiegeWorkbenchRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] astring = SiegeWorkbenchRecipe.shrink(SiegeWorkbenchRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList<CountIngredient> list = SiegeWorkbenchRecipe.dissolvePattern(astring, map, i, j);
            ItemStack result = SiegeWorkbenchRecipe.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new SiegeWorkbenchRecipe(recipeid, i, j, (List<CountIngredient>)list, result);
        }

        public SiegeWorkbenchRecipe fromNetwork(ResourceLocation recipeid, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            int j = buffer.m_130242_();
            NonNullList list = NonNullList.m_122780_((int)(i * j), (Object)CountIngredient.of(Ingredient.f_43901_));
            for (int k = 0; k < list.size(); ++k) {
                list.set(k, (Object)CountIngredient.fromNetwork(buffer));
            }
            ItemStack itemstack = buffer.m_130267_();
            return new SiegeWorkbenchRecipe(recipeid, i, j, (List<CountIngredient>)list, itemstack);
        }

        public void toNetwork(FriendlyByteBuf buffer, SiegeWorkbenchRecipe pRecipe) {
            buffer.m_130130_(pRecipe.width);
            buffer.m_130130_(pRecipe.height);
            for (CountIngredient ingredient : pRecipe.recipeitems) {
                ingredient.toNetwork(buffer);
            }
            buffer.m_130055_(pRecipe.result);
        }
    }

    public static class Type
    implements RecipeType<SiegeWorkbenchRecipe> {
        public static final Type INSTANCE = new Type();

        public String toString() {
            return TYPE_ID.toString();
        }
    }
}

