/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.network;

import io.netty.channel.ChannelHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import ru.magistu.siegemachines.entity.machine.Machine;

@ChannelHandler.Sharable
public class S2CPacketMachineUse {
    private final int entityid;

    public S2CPacketMachineUse(int entityid) {
        this.entityid = entityid;
    }

    public static S2CPacketMachineUse read(FriendlyByteBuf buf) {
        return new S2CPacketMachineUse(buf.readInt());
    }

    public static void write(S2CPacketMachineUse message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityid);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSide(S2CPacketMachineUse packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Entity entity = player.m_9236_().m_6815_(packet.entityid);
        if (entity instanceof Machine) {
            Machine machine = (Machine)entity;
            machine.use((LivingEntity)player);
        }
    }

    public static class Handler {
        public static void handle(S2CPacketMachineUse packet, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                context.enqueueWork(() -> S2CPacketMachineUse.handleClientSide(packet));
            }
            context.setPacketHandled(true);
        }
    }
}

