/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.plugins.jei;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import ru.magistu.siegemachines.block.ModBlocks;
import ru.magistu.siegemachines.item.recipes.CountIngredient;
import ru.magistu.siegemachines.item.recipes.SiegeWorkbenchRecipe;

public class SiegeWorkbenchRecipeCategory
implements IRecipeCategory<SiegeWorkbenchRecipe> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("siegemachines", "textures/gui/siege_workbench.png");
    public static final ResourceLocation UID = new ResourceLocation("siegemachines", "siege_workbench_recipe_category");
    public static final RecipeType<SiegeWorkbenchRecipe> RECIPE_TYPE = new RecipeType(UID, SiegeWorkbenchRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public SiegeWorkbenchRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 29, 16, 116, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.SIEGE_WORKBENCH.get()));
    }

    public RecipeType<SiegeWorkbenchRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"category.siegemachines.siege_workbench_crafting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull SiegeWorkbenchRecipe recipe, @Nonnull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 94, 18).addItemStack(SiegeWorkbenchRecipeCategory.getResultItem(recipe));
        List<CountIngredient> grid = recipe.getRecipeItems();
        for (int i = 0; i < recipe.getWidth(); ++i) {
            for (int j = 0; j < recipe.getHeight(); ++j) {
                builder.addSlot(RecipeIngredientRole.INPUT, i * 18, j * 18).addItemStacks(grid.get(i + j * 3).getCountModifiedItemStacks());
            }
        }
    }

    public static ItemStack getResultItem(Recipe<?> recipe) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.m_9598_();
        return recipe.m_8043_(registryAccess);
    }
}

