/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import ru.magistu.siegemachines.config.MissileSpecs;
import ru.magistu.siegemachines.config.SiegeMachineSpecs;

public final class SpecsConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Double> FIRE_DAMAGE_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Double> EXPLOSION_DAMAGE_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Double> ARROW_DAMAGE_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ALLOW_FRIENDLY_FIRE;
    public static final ForgeConfigSpec.ConfigValue<Integer> DEPLOYMENT_SICKNESS_COOLDOWN;
    public static final ForgeConfigSpec.ConfigValue<Integer> PREVENT_PICKUP_COOLDOWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_SMOOTH_IMPACT;
    public static final SiegeMachineSpecs MORTAR;
    public static final SiegeMachineSpecs CULVERIN;
    public static final SiegeMachineSpecs TREBUCHET;
    public static final SiegeMachineSpecs CATAPULT;
    public static final SiegeMachineSpecs BALLISTA;
    public static final SiegeMachineSpecs BATTERING_RAM;
    public static final SiegeMachineSpecs SIEGE_LADDER;
    public static final MissileSpecs CANNONBALL;
    public static final MissileSpecs STONE;
    public static final MissileSpecs GIANT_STONE;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "siege-machines-specs.toml");
    }

    static {
        BUILDER.push("siege_machines");
        FIRE_DAMAGE_MULTIPLIER = BUILDER.define("fireDamageMultiplier", (Object)3.0);
        EXPLOSION_DAMAGE_MULTIPLIER = BUILDER.define("explosionDamageMultiplier", (Object)2.0);
        ARROW_DAMAGE_MULTIPLIER = BUILDER.define("arrowDamageMultiplier", (Object)0.5);
        ALLOW_FRIENDLY_FIRE = BUILDER.define("allowFriendlyFire", false);
        DEPLOYMENT_SICKNESS_COOLDOWN = BUILDER.define("deploymentSicknessCooldown", (Object)300);
        PREVENT_PICKUP_COOLDOWN = BUILDER.define("preventPickupCooldown", (Object)300);
        ENABLE_SMOOTH_IMPACT = BUILDER.define("enableSmoothImpact", true);
        MORTAR = new SiegeMachineSpecs(BUILDER, "mortar", 80, 200, 2.5f, 0.2f, 1.5f, 0.5f);
        CULVERIN = new SiegeMachineSpecs(BUILDER, "culverin", 150, 260, 3.5f, 0.03f, 3.0f, 0.6f);
        TREBUCHET = new SiegeMachineSpecs(BUILDER, "trebuchet", 350, 400, 2.8f, 0.2f, 3.0f, 1.0f);
        CATAPULT = new SiegeMachineSpecs(BUILDER, "catapult", 150, 200, 2.0f, 0.2f, 1.0f, 0.8f);
        BALLISTA = new SiegeMachineSpecs(BUILDER, "ballista", 70, 120, 4.5f, 0.04f, 1.2f, 0.4f);
        BATTERING_RAM = new SiegeMachineSpecs(BUILDER, "battering_ram", 500, 100, 0.0f, 0.5f, 1.3f, 1.0f);
        SIEGE_LADDER = new SiegeMachineSpecs(BUILDER, "siege_ladder", 400, 0, 0.0f, 0.0f, 0.0f, 1.0f);
        BUILDER.pop();
        BUILDER.push("missiles");
        CANNONBALL = new MissileSpecs(BUILDER, "cannonball", 15.0f, 3.0f, false);
        STONE = new MissileSpecs(BUILDER, "stone", 50.0f, 2.0f, false);
        GIANT_STONE = new MissileSpecs(BUILDER, "giant_stone", 70.0f, 5.0f, false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

