/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import ru.magistu.siegemachines.client.ModSoundTypes;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.machine.ShootingMachine;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Cannon
extends ShootingMachine
implements GeoEntity {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public double wheelspitch = 0.0;
    public double lastwheelpitch;
    private int wheelssoundticks = 10;

    public Cannon(EntityType<? extends Mob> entitytype, Level level, MachineType type) {
        super(entitytype, level, type);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_().equals(Items.f_42409_)) {
            if (this.getUseTicks() <= 0 && this.shootingticks <= 0) {
                stack.m_41622_(1, (LivingEntity)player, p -> {
                    p.m_21190_(hand);
                    ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)this.f_20935_, (InteractionHand)hand);
                });
                this.startShooting((LivingEntity)player);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_().equals(Items.f_42403_)) {
            if (!this.inventory.containsItem(Items.f_42403_) && this.inventory.canAddItem(stack)) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.inventory.addItem(stack);
            }
            return InteractionResult.SUCCESS;
        }
        if (super.m_6071_(player, hand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (!this.m_9236_().m_5776_() && !this.m_20160_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void useRelease() {
        LivingEntity passenger;
        if (this.inventory.containsItem(Items.f_42403_)) {
            super.useRelease();
        } else if (!this.m_9236_().m_5776_() && (passenger = this.m_6688_()) instanceof Player) {
            passenger.m_213846_((Component)Component.m_237115_((String)"siegemachines.no_gunpowder").m_130940_(ChatFormatting.RED));
        }
    }

    public void m_7023_(Vec3 velocity) {
        if (this.m_6084_()) {
            if (this.getDelayTicks() <= 0 && this.m_20160_()) {
                LivingEntity livingentity = this.m_6688_();
                float f0 = livingentity.f_20900_ * 0.2f;
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.5f;
                }
                this.m_7910_(0.04f);
                velocity = new Vec3((double)f0, velocity.f_82480_, (double)f1);
            }
            super.m_7023_(velocity);
        }
    }

    @Override
    public void m_8119_() {
        LivingEntity passenger;
        this.lastwheelpitch = this.wheelspitch;
        this.wheelspitch += this.getWheelsSpeed();
        if (this.m_9236_().m_5776_() && this.m_217005_() && this.getWheelsSpeed() > 0.0081 && this.wheelssoundticks-- <= 0 && Minecraft.m_91087_().f_91074_ == (passenger = this.m_6688_())) {
            Vec3 pos = this.m_20182_();
            this.m_9236_().m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)ModSoundTypes.CANNON_WHEELS.get(), this.m_5720_(), 1.5f, 0.85f + this.m_9236_().f_46441_.m_188501_() * 0.3f, false);
            this.wheelssoundticks = 20;
        }
        if (!this.m_9236_().m_5776_() && this.m_20096_()) {
            this.m_20256_(this.getWheelsDeltaMovement());
        }
        super.m_8119_();
    }

    public double getLerpedWheelPitch(float partialTick) {
        return Mth.m_14139_((double)partialTick, (double)this.lastwheelpitch, (double)this.wheelspitch);
    }

    @Override
    public void startShooting(LivingEntity entity) {
        if (this.getDelayTicks() <= 0 && this.getUseTicks() <= 0 && this.shootingticks <= 0) {
            this.usesoundplayer.run();
            this.setUseTicks(this.f_19847_.usetime);
            this.shootingticks = this.f_19847_.usereleasetime;
        }
    }

    @Override
    public void shoot() {
        if (!this.m_9236_().m_5776_()) {
            super.shoot();
            this.m_20256_(this.m_20184_().m_82546_(this.getShotView().m_82490_(0.25)));
            this.f_19812_ = true;
            this.inventory.removeItemType(Items.f_42403_, 1);
        } else {
            this.blowParticles((ParticleOptions)ParticleTypes.f_123744_, 0.035, 25);
            this.blowParticles((ParticleOptions)ParticleTypes.f_123796_, 0.2, 60);
        }
    }

    public double getWheelsSpeed() {
        if (this.m_20096_()) {
            return this.m_20252_(0.5f).m_82542_(1.0, 0.0, 1.0).m_82526_(this.m_20184_());
        }
        return 0.0;
    }

    public Vec3 getWheelsDeltaMovement() {
        if (this.m_20096_()) {
            Vec3 view = this.m_20252_(1.0f);
            Vec3 movement = this.m_20184_();
            double d0 = movement.f_82479_ * view.f_82479_ + movement.f_82481_ * view.f_82481_;
            double d1 = d0 * view.f_82479_;
            double d2 = 0.0;
            double d3 = d0 * view.f_82481_;
            return new Vec3(d1, d2, d3);
        }
        return Vec3.f_82478_;
    }
}

