/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ru.magistu.siegemachines.ModTags;
import ru.magistu.siegemachines.api.enitity.Useable;
import ru.magistu.siegemachines.config.SpecsConfig;
import ru.magistu.siegemachines.entity.machine.ItemStackListSerializer;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.util.CartesianGeometry;
import ru.magistu.siegemachines.util.HitUtil;

public abstract class Machine
extends Mob
implements MenuProvider,
Useable {
    public MachineInventory inventory;
    public final MachineType f_19847_;
    protected float turretpitchprev = -25.0f;
    protected float turretpitchdest = -25.0f;
    protected float turretyawprev = this.getTurretYaw();
    protected float turretyawdest = this.getTurretYaw();
    protected float yawdest = this.m_146908_();
    private boolean stationary;
    private static final EntityDataAccessor<Float> DATA_TURRET_PITCH = SynchedEntityData.m_135353_(Machine.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_TURRET_YAW = SynchedEntityData.m_135353_(Machine.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_USE_TICKS = SynchedEntityData.m_135353_(Machine.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_DELAY_TICKS = SynchedEntityData.m_135353_(Machine.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PREVENT_PICKUP_TICKS = SynchedEntityData.m_135353_(Machine.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<List<ItemStack>> DATA_INVENTORY_ITEMS = SynchedEntityData.m_135353_(Machine.class, (EntityDataSerializer)ItemStackListSerializer.INSTANCE);
    protected int deploymentticks = 0;
    protected Runnable reloadsoundplayer;
    protected Runnable usesoundplayer;
    protected Runnable usereleasesoundplayer;
    protected static final int USE_RELEASE = 66;

    protected Machine(EntityType<? extends Mob> entitytype, Level level, MachineType type) {
        super(entitytype, level);
        this.f_19847_ = type;
        this.setDelayTicks((Integer)type.specs.delaytime.get());
        this.inventory = new MachineInventory(this.f_19847_.containerrows);
        this.applyAttributeSpecs();
        this.m_21153_(((Integer)type.specs.durability.get()).intValue());
        this.setTurretRotations(-type.turretinitpitch, type.turretinityaw);
        this.turretpitchprev = -type.turretinitpitch;
        this.turretyawprev = type.turretinityaw;
        this.setTurretRotationsDest(-type.turretinitpitch, type.turretinityaw);
        this.reloadsoundplayer = this.f_19847_.reloadsoundduration > 0 && this.f_19847_.reloadvolume > 0.0f && this.f_19847_.reloadsound != null ? this::playReloadSound : () -> {};
        this.usesoundplayer = this.f_19847_.usevolume > 0.0f && this.f_19847_.usesound != null ? this::playUseSound : () -> {};
        this.usereleasesoundplayer = this.f_19847_.usereleasevolume > 0.0f && this.f_19847_.usereleasesound != null ? this::playUseReleaseSound : () -> {};
    }

    public void applyAttributeSpecs() {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)((Integer)this.f_19847_.specs.durability.get()).intValue());
        double knockbackresistance = (Double)this.f_19847_.specs.knockbackresistance.get();
        this.m_21051_(Attributes.f_22278_).m_22100_(knockbackresistance);
        this.stationary = knockbackresistance > 0.949;
    }

    public void setDeploymentTicks(int value) {
        this.deploymentticks = value;
    }

    public static AttributeSupplier.Builder setEntityAttributes(MachineType type) {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (double)((Integer)type.specs.durability.getDefault()).intValue()).m_22268_(Attributes.f_22278_, ((Double)type.specs.knockbackresistance.getDefault()).doubleValue()).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TURRET_PITCH, (Object)Float.valueOf(-25.0f));
        this.f_19804_.m_135372_(DATA_TURRET_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_USE_TICKS, (Object)0);
        this.f_19804_.m_135372_(DATA_DELAY_TICKS, (Object)0);
        this.f_19804_.m_135372_(PREVENT_PICKUP_TICKS, (Object)0);
        this.f_19804_.m_135372_(DATA_INVENTORY_ITEMS, new ArrayList());
    }

    public boolean m_6673_(DamageSource damagesource) {
        return damagesource.m_269533_(ModTags.DamageTypes.MACHINE_IMMUNE_TO) || super.m_6673_(damagesource);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (this.m_21224_()) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268745_) && this.m_21023_(MobEffects.f_19607_)) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (source.m_276093_(DamageTypes.f_268464_) && this.canDropAsItem()) {
                if (this.getPreventPickupTicks() > 0) {
                    player.m_213846_((Component)Component.m_237110_((String)"siegemachines.wait", (Object[])new Object[]{Float.valueOf((float)this.getPreventPickupTicks() / 20.0f)}).m_130940_(ChatFormatting.RED));
                } else {
                    this.m_19983_(this.getMachineItemWithData());
                    this.m_5907_();
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                return false;
            }
        }
        this.setPreventPickupTicks((Integer)SpecsConfig.PREVENT_PICKUP_COOLDOWN.get());
        return super.m_6469_(source, this.adjustDamage(source, amount));
    }

    protected boolean canDropAsItem() {
        return this.m_20197_().isEmpty();
    }

    public float adjustDamage(DamageSource damagesource, float f) {
        if (damagesource.m_269533_(DamageTypeTags.f_268745_)) {
            f *= ((Double)SpecsConfig.FIRE_DAMAGE_MULTIPLIER.get()).floatValue();
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268415_)) {
            f *= ((Double)SpecsConfig.EXPLOSION_DAMAGE_MULTIPLIER.get()).floatValue();
        }
        if (damagesource.m_276093_(DamageTypes.f_268739_)) {
            f *= ((Double)SpecsConfig.ARROW_DAMAGE_MULTIPLIER.get()).floatValue();
        }
        return f;
    }

    public Item getMachineItem() {
        return this.f_19847_.machineitem.get();
    }

    public void m_8119_() {
        int delayticks;
        int useticks = this.getUseTicks();
        if (useticks > 0) {
            this.setUseTicks(--useticks);
            if (useticks <= 0) {
                this.setUseTicks(0);
                this.setDelayTicks((Integer)this.f_19847_.specs.delaytime.get());
            }
        }
        if (this.isStationary() && !this.m_9236_().m_5776_()) {
            this.stop();
        }
        if ((delayticks = this.getDelayTicks()) > 0 && this.m_217005_()) {
            if (delayticks % this.f_19847_.reloadsoundduration == 0) {
                this.reloadsoundplayer.run();
            }
            this.setDelayTicks(--delayticks);
        }
        if (this.deploymentticks > 0) {
            --this.deploymentticks;
        }
        if (this.getPreventPickupTicks() > 0) {
            this.setPreventPickupTicks(this.getPreventPickupTicks() - 1);
        }
        super.m_8119_();
    }

    public void stop() {
        Vec3 delta = this.m_20184_();
        double y = Math.min(delta.f_82480_, 0.0);
        Vec3 adjusted = new Vec3(0.0, y, 0.0);
        this.m_20256_(adjusted);
        this.m_7910_(0.0f);
        if (adjusted.m_82556_() < 1.0E-6) {
            this.f_19812_ = false;
        }
    }

    private void playReloadSound() {
        Vec3 pos = this.m_20182_();
        this.m_9236_().m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, this.f_19847_.reloadsound.get(), this.m_5720_(), this.f_19847_.reloadvolume, 1.0f, false);
    }

    private void playUseSound() {
        Vec3 pos = this.m_20182_();
        this.m_9236_().m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, this.f_19847_.usesound.get(), this.m_5720_(), this.f_19847_.usevolume, 1.0f, false);
    }

    private void playUseReleaseSound() {
        Vec3 pos = this.m_20182_();
        this.m_9236_().m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, this.f_19847_.usereleasesound.get(), this.m_5720_(), this.f_19847_.usereleasevolume, 1.0f, false);
    }

    public float m_7077_(Explosion explosion, BlockGetter level, BlockPos pos, BlockState blockState, FluidState fluidState, float resistance) {
        if (resistance < 4.3f) {
            return 3.0f;
        }
        return resistance * 0.7f;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource p_184601_1_) {
        return null;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity livingentity;
        Entity entity = this.m_146895_();
        return entity instanceof LivingEntity ? (livingentity = (LivingEntity)entity) : super.m_6688_();
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag listnbt = new ListTag();
        for (ItemStack itemstack : this.inventory.getItems()) {
            CompoundTag compound = new CompoundTag();
            if (!itemstack.m_41619_()) {
                itemstack.m_41739_(compound);
            }
            listnbt.add((Object)compound);
        }
        nbt.m_128365_("Items", (Tag)listnbt);
        nbt.m_128365_("TurretRotations", (Tag)this.m_20065_(new float[]{this.getTurretPitch(), this.getTurretYaw()}));
        nbt.m_128405_("DelayTicks", this.getDelayTicks());
        nbt.m_128405_("UseTicks", this.getUseTicks());
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("Items", 9)) {
            ListTag listnbt = nbt.m_128437_("Items", 10);
            for (int i = 0; i < this.inventory.getItems().size(); ++i) {
                this.inventory.getItems().set(i, ItemStack.m_41712_((CompoundTag)listnbt.m_128728_(i)));
            }
        }
        if (nbt.m_128425_("TurretRotations", 5)) {
            ListTag turretrotations = nbt.m_128437_("TurretRotations", 5);
            this.setTurretRotations(turretrotations.m_128775_(0), turretrotations.m_128775_(1));
        }
        if (nbt.m_128441_("DelayTicks")) {
            this.setDelayTicks(nbt.m_128451_("DelayTicks"));
        }
        if (nbt.m_128441_("UseTicks")) {
            this.setUseTicks(nbt.m_128451_("UseTicks"));
        }
    }

    public ItemStack getMachineItemWithData() {
        ItemStack stack = new ItemStack((ItemLike)this.getMachineItem());
        CompoundTag nbt = new CompoundTag();
        this.m_20240_(nbt);
        nbt.m_128473_("Pos");
        nbt.m_128473_("Motion");
        nbt.m_128473_("FallDistance");
        nbt.m_128473_("Fire");
        nbt.m_128473_("Air");
        nbt.m_128473_("OnGround");
        nbt.m_128473_("Invulnerable");
        nbt.m_128473_("PortalCooldown");
        nbt.m_128473_("UUID");
        nbt.m_128473_("Passengers");
        nbt.m_128473_("DelayTicks");
        nbt.m_128473_("UseTicks");
        nbt.m_128473_("Items");
        String id = this.m_20078_();
        if (id != null) {
            nbt.m_128359_("id", id);
        }
        stack.m_41700_("EntityTag", (Tag)nbt);
        return stack;
    }

    protected void m_7472_(DamageSource damageSource, int i, boolean recentlyHit) {
        Arrays.stream(this.f_19847_.wreckage.get()).forEach(arg_0 -> ((Machine)this).m_19983_(arg_0));
    }

    protected void m_5907_() {
        super.m_5907_();
        this.inventory.getItems().forEach(arg_0 -> ((Machine)this).m_19983_(arg_0));
        this.inventory.m_6211_();
    }

    @Override
    public float getGlobalTurretYaw() {
        return Mth.m_14179_((float)0.5f, (float)this.f_19859_, (float)this.m_146908_()) + this.getTurretYaw();
    }

    public float getYaw() {
        return this.m_146908_();
    }

    public void setYaw(float yaw) {
        this.m_146922_(yaw);
        this.f_19859_ = this.m_146908_();
        this.f_20885_ = this.f_20883_ = this.m_146908_();
    }

    public float getYawDest() {
        return this.yawdest;
    }

    @Override
    public void setYawDest(float yaw) {
        this.yawdest = yaw;
    }

    public float getTurretPitch(float f) {
        return Mth.m_14179_((float)f, (float)this.turretpitchprev, (float)((Float)this.f_19804_.m_135370_(DATA_TURRET_PITCH)).floatValue());
    }

    public float getTurretYaw(float f) {
        return Mth.m_14179_((float)f, (float)this.turretyawprev, (float)((Float)this.f_19804_.m_135370_(DATA_TURRET_YAW)).floatValue());
    }

    @Override
    public float getTurretPitch() {
        return this.getTurretPitch(0.5f);
    }

    @Override
    public float getTurretYaw() {
        return this.getTurretYaw(0.5f);
    }

    public int getUseTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_USE_TICKS);
    }

    public void setUseTicks(int ticks) {
        this.f_19804_.m_135381_(DATA_USE_TICKS, (Object)ticks);
    }

    public int getDelayTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_DELAY_TICKS);
    }

    public void setDelayTicks(int ticks) {
        this.f_19804_.m_135381_(DATA_DELAY_TICKS, (Object)ticks);
    }

    public int getPreventPickupTicks() {
        return (Integer)this.f_19804_.m_135370_(PREVENT_PICKUP_TICKS);
    }

    public void setPreventPickupTicks(int ticks) {
        this.f_19804_.m_135381_(PREVENT_PICKUP_TICKS, (Object)ticks);
    }

    public void setTurretRotations(float pitch, float yaw) {
        this.turretpitchprev = this.getTurretPitch();
        this.turretyawprev = this.getTurretYaw();
        this.setTurretPitch(pitch);
        this.setTurretYaw(yaw);
    }

    protected void setTurretPitch(float pitch) {
        this.f_19804_.m_135381_(DATA_TURRET_PITCH, (Object)Float.valueOf(pitch));
    }

    protected void setTurretYaw(float yaw) {
        this.f_19804_.m_135381_(DATA_TURRET_YAW, (Object)Float.valueOf(yaw));
    }

    public float getTurretPitchDest() {
        return this.turretpitchdest;
    }

    public float getTurretYawDest() {
        return this.turretyawdest;
    }

    @Override
    public void setTurretRotationsDest(float pitch, float yaw) {
        this.turretpitchdest = pitch;
        this.turretyawdest = yaw;
    }

    public void updateYaw() {
        float newyaw = this.turn(this.getYaw(), this.getYawDest(), this.f_19847_.rotationspeed);
        if (this.getYaw() != newyaw) {
            this.setYaw(newyaw);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.m_20160_() && this.getUseTicks() <= 0 && this.getDelayTicks() <= 0) {
            LivingEntity livingentity = this.m_6688_();
            this.setTurretRotationsDest(livingentity.m_146909_(), livingentity.m_146908_() - this.getYaw());
            this.setYawDest(livingentity.m_146908_());
            this.updateYaw();
            this.updateTurretRotations();
        }
    }

    public void updateTurretRotations() {
        float newpitch;
        float newyaw = this.turn(this.getTurretYaw(), this.getTurretYawDest(), this.f_19847_.turretspeed, this.f_19847_.turretminyaw, this.f_19847_.turretmaxyaw);
        boolean shouldrotate = this.checkYaw(newyaw, this.getTurretYaw(), this.f_19847_.turretspeed);
        float f = newpitch = shouldrotate ? this.turn(this.getTurretPitch(), this.getTurretPitchDest(), this.f_19847_.turretspeed, this.f_19847_.turretminpitch, this.f_19847_.turretmaxpitch) : this.getTurretPitch();
        if (this.getTurretPitch() != newpitch || this.getTurretYaw() != newyaw) {
            this.setTurretRotations(newpitch, newyaw);
        }
    }

    public boolean checkYaw(float yaw, float currentYaw, float speed) {
        return !this.f_19847_.yawfirst || Math.abs(yaw - currentYaw) <= speed / 2.0f || yaw <= this.f_19847_.turretminyaw || yaw >= this.f_19847_.turretmaxyaw;
    }

    public float turn(float rotation, float rotationDest, float speed) {
        return this.turn(rotation, rotationDest, speed, -180.0f, 180.0f);
    }

    public float turn(float rotation, float rotationDest, float speed, float minRotation, float maxRotation) {
        boolean hasLimit = maxRotation - minRotation < 360.0f;
        float deltaRotation = rotationDest - rotation;
        float newRotation = (deltaRotation = Mth.m_14177_((float)deltaRotation)) > speed / 2.0f ? rotation + speed : (deltaRotation < -speed / 2.0f ? rotation - speed : rotation + deltaRotation / 2.0f);
        if (hasLimit) {
            if (newRotation > -minRotation) {
                newRotation = -minRotation;
            }
            if (newRotation < -maxRotation) {
                newRotation = -maxRotation;
            }
        }
        return newRotation;
    }

    public void m_7822_(byte id) {
        if (id == 66) {
            this.useRelease();
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    public abstract void use(LivingEntity var1);

    public abstract void useRelease();

    public ChestMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new ChestMenu(MenuType.f_39957_, id, inv, (Container)this.inventory, 1);
    }

    public void openInventoryGui() {
        LivingEntity passenger = this.m_6688_();
        if (passenger instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)passenger;
            this.m_8127_();
            serverPlayer.m_5893_((MenuProvider)this);
        }
    }

    public Vec3 m_7688_(LivingEntity entity) {
        double yaw;
        Vec3 delta;
        Vec3 origin = this.m_20182_();
        HitResult hit = HitUtil.getBlockHitResult(origin, delta = CartesianGeometry.applyRotations(this.f_19847_.passengerpos, 0.0, yaw = (double)this.getGlobalTurretYaw() * Math.PI / 180.0), this.m_9236_(), ClipContext.Block.COLLIDER);
        if (hit.m_6662_() == HitResult.Type.MISS) {
            return origin.m_82549_(delta);
        }
        return hit.m_82450_();
    }

    public void m_19956_(@NotNull Entity entity, @NotNull Entity.MoveFunction moveFunction) {
        Entity.MoveFunction setPos = Entity::m_6034_;
        if (this.m_20363_(entity)) {
            double yaw = (double)this.getGlobalTurretYaw() * Math.PI / 180.0;
            Vec3 pos = this.m_20182_().m_82549_(CartesianGeometry.applyRotations(this.f_19847_.passengerpos, 0.0, yaw));
            setPos.m_20372_(entity, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean isStationary() {
        return this.stationary;
    }

    public int getDelayTime() {
        return (Integer)this.f_19847_.specs.delaytime.get();
    }

    public AABB m_6921_() {
        AABB box = this.m_20191_();
        return box.m_82377_(box.m_82362_(), box.m_82376_(), box.m_82385_());
    }

    public double getExplosionDamageMultiplier() {
        return (Double)this.f_19847_.specs.explosiondamagemultiplier.get();
    }

    public class MachineInventory
    implements Container,
    StackedContentsCompatible,
    Nameable {
        private final int size;

        public MachineInventory(int rows) {
            this.size = 9 * rows;
            this.setItems(IntStream.range(0, this.size).boxed().map(i -> ItemStack.f_41583_).collect(Collectors.collectingAndThen(Collectors.toList(), ArrayList::new)));
        }

        public int m_6643_() {
            return this.size;
        }

        public boolean m_7983_() {
            return this.getItems().isEmpty();
        }

        public void setItems(List<ItemStack> itemstacks) {
            Machine.this.f_19804_.m_135381_(DATA_INVENTORY_ITEMS, itemstacks);
        }

        @NotNull
        public List<ItemStack> getItems() {
            return (List)Machine.this.f_19804_.m_135370_(DATA_INVENTORY_ITEMS);
        }

        public void m_6596_() {
            Machine.this.f_19804_.m_276349_(DATA_INVENTORY_ITEMS, this.getItems(), true);
        }

        @NotNull
        public ItemStack m_8020_(int i) {
            return this.getItems().get(i);
        }

        @NotNull
        public ItemStack m_7407_(int i, int count) {
            ItemStack itemstack = ContainerHelper.m_18969_(this.getItems(), (int)i, (int)count);
            if (!itemstack.m_41619_()) {
                this.m_6596_();
            }
            return itemstack;
        }

        @NotNull
        public ItemStack m_8016_(int i) {
            return ContainerHelper.m_18969_(this.getItems(), (int)i, (int)1);
        }

        public void m_6836_(int i, @NotNull ItemStack stack) {
            this.getItems().set(i, stack);
            if (!this.m_7983_() && stack.m_41613_() > this.m_6893_()) {
                stack.m_41764_(this.m_6893_());
            }
            this.m_6596_();
        }

        public boolean m_6542_(@NotNull Player player) {
            return true;
        }

        public void m_6211_() {
            this.setItems((List<ItemStack>)NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_));
        }

        public boolean containsItem(Item item) {
            return this.getItems().stream().anyMatch(itemStack -> itemStack.m_41720_().equals(item));
        }

        public boolean canAddItem(ItemStack stack) {
            boolean flag = false;
            for (ItemStack itemstack : this.getItems()) {
                if (!itemstack.m_41619_() && (!ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)stack) || itemstack.m_41613_() >= itemstack.m_41741_())) continue;
                flag = true;
                break;
            }
            return flag;
        }

        public ItemStack addItem(ItemStack stack) {
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            ItemStack itemstack = stack.m_41777_();
            this.moveItemToOccupiedSlotsWithSameType(itemstack);
            if (itemstack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            this.moveItemToEmptySlots(itemstack);
            return itemstack.m_41619_() ? ItemStack.f_41583_ : itemstack;
        }

        private void moveItemToOccupiedSlotsWithSameType(ItemStack stack) {
            for (int i = 0; i < this.size; ++i) {
                ItemStack itemstack = this.m_8020_(i);
                if (!ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)stack)) continue;
                this.moveItemsBetweenStacks(stack, itemstack);
                if (!stack.m_41619_()) continue;
                return;
            }
        }

        private void moveItemsBetweenStacks(ItemStack stack, ItemStack other) {
            int i = this.m_6893_();
            int j = Math.min(stack.m_41613_(), i - other.m_41613_());
            if (j > 0) {
                other.m_41769_(j);
                stack.m_41774_(j);
                this.m_6596_();
            }
        }

        private void moveItemToEmptySlots(ItemStack stack) {
            for (int i = 0; i < this.size; ++i) {
                ItemStack itemstack = this.m_8020_(i);
                if (!itemstack.m_41619_()) continue;
                this.m_6836_(i, stack.m_278832_());
                return;
            }
        }

        public ItemStack removeItemType(Item item, int amount) {
            ItemStack itemstack = new ItemStack((ItemLike)item, 0);
            for (int i = this.size - 1; i >= 0; --i) {
                ItemStack itemstack1 = this.m_8020_(i);
                if (!itemstack1.m_41720_().equals(item)) continue;
                int j = amount - itemstack.m_41613_();
                ItemStack itemstack2 = itemstack1.m_41620_(j);
                itemstack.m_41769_(itemstack2.m_41613_());
                if (itemstack.m_41613_() == amount) break;
            }
            if (!itemstack.m_41619_()) {
                this.m_6596_();
            }
            return itemstack;
        }

        @NotNull
        public Component m_7755_() {
            return Machine.this.m_7755_();
        }

        public void m_5809_(@NotNull StackedContents helper) {
            for (ItemStack itemstack : this.getItems()) {
                helper.m_36491_(itemstack);
            }
        }
    }
}

