/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import ru.magistu.siegemachines.ModTags;
import ru.magistu.siegemachines.config.SpecsConfig;
import ru.magistu.siegemachines.entity.machine.Machine;
import ru.magistu.siegemachines.entity.projectile.FlightType;
import ru.magistu.siegemachines.entity.projectile.MachineBasedExplosionDamageCalculator;
import ru.magistu.siegemachines.entity.projectile.MissileExplosion;
import ru.magistu.siegemachines.entity.projectile.MissileType;
import ru.magistu.siegemachines.util.CombatUtil;

public abstract class Missile
extends ThrowableItemProjectile {
    public MissileType f_19847_ = MissileType.STONE;
    protected Entity engine = null;

    public Missile(EntityType<? extends Missile> entitytype, Level level) {
        super(entitytype, level);
    }

    public Missile(EntityType<? extends Missile> entitytype, Level level, Vector3d pos, LivingEntity shooter, Entity engine, MissileType type) {
        super(entitytype, shooter.m_6688_() != null ? shooter.m_6688_() : shooter, level);
        this.f_19847_ = type;
        this.engine = engine;
        this.m_6034_(pos.x, pos.y, pos.z);
    }

    public void m_6532_(HitResult result) {
        Entity entity;
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            Vec3 vector3d;
            EntityHitResult entityRTR = (EntityHitResult)result;
            Vec3 pos = entityRTR.m_82450_();
            Entity entity2 = entityRTR.m_82443_();
            float damage = (float)((Double)this.f_19847_.specs.mass.get() * this.m_20184_().m_82553_());
            DamageSource damagesource = this.m_269291_().m_269390_((Entity)this, this.m_19749_());
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity2;
                damage += this.f_19847_.armorpiercing * (damage - CombatRules.m_19272_((float)damage, (float)livingentity.m_21230_(), (float)((float)livingentity.m_21051_(Attributes.f_22285_).m_22135_())));
            }
            if (!this.m_9236_().m_5776_() && this.f_19847_.explosive) {
                this.explode(pos.f_82479_, pos.f_82480_, pos.f_82481_, Explosion.BlockInteraction.DESTROY);
                this.m_146870_();
            }
            if (this.canHurt(entity2)) {
                entity2.m_6469_(damagesource, damage);
            }
            if ((vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.f_19847_.knockback * 0.6)).m_82556_() > 0.0) {
                entity2.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
            }
        }
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            boolean smoothimpact;
            BlockHitResult blockRTR = (BlockHitResult)result;
            BlockPos blockpos = blockRTR.m_82425_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            boolean bl = smoothimpact = (Boolean)SpecsConfig.ENABLE_SMOOTH_IMPACT.get() != false && blockstate.m_204336_(ModTags.Blocks.SMOOTH_IMPACT) && blockRTR.m_82434_() == Direction.UP;
            if (blockRTR.m_82434_() == Direction.UP) {
                if (this.f_19847_.explosive) {
                    int r = 0;
                    while ((double)r < (Double)this.f_19847_.specs.explosionpower.get()) {
                        for (int a = 0; a < 8; ++a) {
                            float i = (float)((double)a * Math.PI / 4.0);
                            BlockPos pos = blockRTR.m_82425_();
                            BlockPos pos2 = BlockPos.m_274561_((double)((float)pos.m_123341_() + (float)r * Mth.m_14089_((float)i)), (double)pos.m_123342_(), (double)((float)pos.m_123343_() - (float)r * Mth.m_14031_((float)i)));
                            if (this.m_9236_().m_8055_(pos2) != Blocks.f_50440_.m_49966_()) continue;
                            this.m_9236_().m_46597_(pos2, Blocks.f_50493_.m_49966_());
                        }
                        ++r;
                    }
                }
                if (!this.m_9236_().m_5776_()) {
                    this.m_146870_();
                    if (smoothimpact && this.f_19847_.explosive) {
                        this.explode(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), Explosion.BlockInteraction.KEEP);
                    }
                } else if (smoothimpact) {
                    this.dustExplosion((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), blockpos, (Double)this.f_19847_.specs.explosionpower.get() / 2.0, 50);
                }
            }
            if (!this.m_9236_().m_5776_() && !smoothimpact && this.f_19847_.explosive) {
                this.explode(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), Explosion.BlockInteraction.DESTROY);
            }
        }
        if (result.m_6662_() == HitResult.Type.MISS && (entity = this.m_19749_()) instanceof Player) {
            Player player = (Player)entity;
            this.m_9236_().m_5594_(player, this.m_20097_(), SoundEvents.f_11664_, SoundSource.AMBIENT, 1.0f, 1.0f);
            if (!this.m_9236_().m_5776_()) {
                this.m_146870_();
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    private ExplosionDamageCalculator getExplosionDamageCalculator() {
        if (this.engine == null) {
            return new ExplosionDamageCalculator();
        }
        Entity entity = this.engine;
        if (entity instanceof Machine) {
            Machine machine = (Machine)entity;
            return new MachineBasedExplosionDamageCalculator(machine);
        }
        return new EntityBasedExplosionDamageCalculator(this.engine);
    }

    public boolean canHurt(Entity victim) {
        return CombatUtil.canHurt(this.m_19749_(), victim);
    }

    private void dustExplosion(ParticleOptions particle, BlockPos blockpos, double speed, int amount) {
        this.dustExplosion(particle, blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), speed, amount);
    }

    private void dustExplosion(ParticleOptions particle, double x, double y, double z, double speed, int amount) {
        for (int i = 0; i < amount; ++i) {
            Vec3 movement = this.m_20184_();
            double d0 = x - 0.05 + this.m_9236_().f_46441_.m_188500_() * 0.3;
            double d1 = y + 1.0;
            double d2 = z - 0.05 + this.m_9236_().f_46441_.m_188500_() * 0.3;
            double d3 = movement.f_82479_ * this.m_9236_().f_46441_.m_188500_() * speed;
            double d4 = -movement.f_82480_ * this.m_9236_().f_46441_.m_188500_() * speed * 10.0;
            double d5 = movement.f_82481_ * this.m_9236_().f_46441_.m_188500_() * speed;
            this.m_9236_().m_7106_(particle, d0, d1, d2, d3, d4, d5);
        }
    }

    public void m_8119_() {
        if (this.f_19847_.flighttype == FlightType.SPINNING) {
            this.m_146926_(this.m_146909_() + 0.5f);
        }
        super.m_8119_();
    }

    public MissileExplosion explode(double x, double y, double z, Explosion.BlockInteraction mode) {
        return this.explode(x, y, z, false, mode);
    }

    public MissileExplosion explode(double x, double y, double z, boolean fired, Explosion.BlockInteraction mode) {
        Entity source = this.m_19749_();
        float size = ((Double)this.f_19847_.specs.explosionpower.get()).floatValue();
        if (this.engine != null) {
            size *= 2.0f;
        }
        Entity directSource = this.getDirectSourceEntityInternal(source);
        LivingEntity indirectSource = this.getIndirectSourceEntityInternal(source);
        MissileExplosion explosion = new MissileExplosion(this.m_9236_(), source, this.m_9236_().m_269111_().m_269036_(directSource, (Entity)indirectSource), this.getExplosionDamageCalculator(), x, y, z, size, fired, mode);
        explosion.m_46061_();
        explosion.m_46075_(true);
        return explosion;
    }

    @Nullable
    private Entity getDirectSourceEntityInternal(@Nullable Entity source) {
        return source == null ? this : (source.m_20202_() == null ? source : source.m_20202_());
    }

    @Nullable
    private LivingEntity getIndirectSourceEntityInternal(@Nullable Entity source) {
        Projectile projectile;
        Entity entity;
        if (source == null) {
            return null;
        }
        if (source instanceof PrimedTnt) {
            PrimedTnt primedtnt = (PrimedTnt)source;
            return primedtnt.m_19749_();
        }
        if (source instanceof Machine) {
            Machine machine = (Machine)source;
            return machine.m_6688_();
        }
        if (source instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)source;
            return livingentity;
        }
        if (source instanceof Projectile && (entity = (projectile = (Projectile)source).m_19749_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            return livingentity;
        }
        return null;
    }
}

