/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.projectile;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import ru.magistu.siegemachines.entity.projectile.MachineBasedExplosionDamageCalculator;
import ru.magistu.siegemachines.util.CombatUtil;

public class MissileExplosion
extends Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private static final int MAX_DROPS_PER_COMBINED_STACK = 16;
    private final boolean fire;
    private final Explosion.BlockInteraction blockInteraction;
    private final RandomSource random = RandomSource.m_216327_();
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final ObjectArrayList<BlockPos> toBlow = new ObjectArrayList();
    private final Map<Player, Vec3> hitPlayers = Maps.newHashMap();
    private final Vec3 position;
    private Entity engine;

    public MissileExplosion(Level p_46024_, @Nullable Entity p_46025_, double p_46026_, double p_46027_, double p_46028_, float p_46029_, List<BlockPos> p_46030_) {
        this(p_46024_, p_46025_, p_46026_, p_46027_, p_46028_, p_46029_, false, Explosion.BlockInteraction.DESTROY_WITH_DECAY, p_46030_);
    }

    public MissileExplosion(Level p_46041_, @Nullable Entity p_46042_, double p_46043_, double p_46044_, double p_46045_, float p_46046_, boolean p_46047_, Explosion.BlockInteraction p_46048_, List<BlockPos> p_46049_) {
        this(p_46041_, p_46042_, p_46043_, p_46044_, p_46045_, p_46046_, p_46047_, p_46048_);
        this.toBlow.addAll(p_46049_);
    }

    public MissileExplosion(Level p_46032_, @Nullable Entity p_46033_, double p_46034_, double p_46035_, double p_46036_, float p_46037_, boolean p_46038_, Explosion.BlockInteraction p_46039_) {
        this(p_46032_, p_46033_, null, null, p_46034_, p_46035_, p_46036_, p_46037_, p_46038_, p_46039_);
    }

    public MissileExplosion(Level p_46051_, @Nullable Entity p_46052_, @Nullable DamageSource p_46053_, @Nullable ExplosionDamageCalculator p_46054_, double p_46055_, double p_46056_, double p_46057_, float p_46058_, boolean p_46059_, Explosion.BlockInteraction p_46060_) {
        super(p_46051_, p_46052_, p_46053_, p_46054_, p_46055_, p_46056_, p_46057_, p_46058_, p_46059_, p_46060_);
        this.level = p_46051_;
        this.source = p_46052_;
        this.radius = p_46058_;
        this.x = p_46055_;
        this.y = p_46056_;
        this.z = p_46057_;
        this.fire = p_46059_;
        this.blockInteraction = p_46060_;
        this.damageSource = p_46053_ == null ? p_46051_.m_269111_().m_269093_((Explosion)this) : p_46053_;
        this.damageCalculator = p_46054_ == null ? this.makeDamageCalculator(p_46052_) : p_46054_;
        this.position = new Vec3(this.x, this.y, this.z);
    }

    private ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity p_46063_) {
        return p_46063_ == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(p_46063_);
    }

    public double getDamageMultiplier() {
        ExplosionDamageCalculator explosionDamageCalculator = this.damageCalculator;
        if (explosionDamageCalculator instanceof MachineBasedExplosionDamageCalculator) {
            MachineBasedExplosionDamageCalculator calc = (MachineBasedExplosionDamageCalculator)explosionDamageCalculator;
            return calc.getExplosionDamageMultiplier();
        }
        return 1.0;
    }

    private boolean canHurt(Entity victim) {
        return victim.m_6688_() != this.source && CombatUtil.canHurt(this.source, victim);
    }

    public static float getSeenPercent(Vec3 p_46065_, Entity p_46066_) {
        AABB aabb = p_46066_.m_20191_();
        double d0 = 1.0 / ((aabb.f_82291_ - aabb.f_82288_) * 2.0 + 1.0);
        double d1 = 1.0 / ((aabb.f_82292_ - aabb.f_82289_) * 2.0 + 1.0);
        double d2 = 1.0 / ((aabb.f_82293_ - aabb.f_82290_) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = Mth.m_14139_((double)d5, (double)aabb.f_82288_, (double)aabb.f_82291_);
                        double d9 = Mth.m_14139_((double)d6, (double)aabb.f_82289_, (double)aabb.f_82292_);
                        double d10 = Mth.m_14139_((double)d7, (double)aabb.f_82290_, (double)aabb.f_82293_);
                        Vec3 vec3 = new Vec3(d8 + d3, d9, d10 + d4);
                        if (p_46066_.m_9236_().m_45547_(new ClipContext(vec3, p_46065_, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, p_46066_)).m_6662_() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public void m_46061_() {
        int l;
        int k;
        this.level.m_220400_(this.source, GameEvent.f_157812_, new Vec3(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (k = 0; k < 16; ++k) {
                block2: for (l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.f_46441_.m_188501_() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.m_274561_((double)d4, (double)d6, (double)d8);
                        BlockState blockstate = this.level.m_8055_(blockpos);
                        FluidState fluidstate = this.level.m_6425_(blockpos);
                        if (!this.level.m_46739_(blockpos)) continue block2;
                        Optional optional = this.damageCalculator.m_6617_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, fluidstate);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.m_6714_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        float f2 = this.radius * 2.0f;
        k = Mth.m_14107_((double)(this.x - (double)f2 - 1.0));
        l = Mth.m_14107_((double)(this.x + (double)f2 + 1.0));
        int i2 = Mth.m_14107_((double)(this.y - (double)f2 - 1.0));
        int i1 = Mth.m_14107_((double)(this.y + (double)f2 + 1.0));
        int j2 = Mth.m_14107_((double)(this.z - (double)f2 - 1.0));
        int j1 = Mth.m_14107_((double)(this.z + (double)f2 + 1.0));
        List list = this.level.m_45933_(this.source, new AABB((double)k, (double)i2, (double)j2, (double)l, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)f2);
        Vec3 vec3 = new Vec3(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Player player;
            double d11;
            double d9;
            double d7;
            double d5;
            double d13;
            Entity entity = (Entity)list.get(k2);
            if (entity.m_6128_()) continue;
            double d12 = Math.sqrt(entity.m_20238_(vec3)) / (double)f2;
            if (!this.canHurt(entity) || !(d12 <= 1.0) || (d13 = Math.sqrt((d5 = entity.m_20185_() - this.x) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y) * d7 + (d9 = entity.m_20189_() - this.z) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = (double)MissileExplosion.getSeenPercent(vec3, entity) * this.getDamageMultiplier();
            double d10 = (1.0 - d12) * d14;
            entity.m_6469_(this.m_46077_(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)));
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)livingentity, (double)d10);
            } else {
                d11 = d10;
            }
            Vec3 vec31 = new Vec3(d5 *= d11, d7 *= d11, d9 *= d11);
            entity.m_20256_(entity.m_20184_().m_82549_(vec31));
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            this.hitPlayers.put(player, vec31);
        }
    }

    public void m_46075_(boolean p_46076_) {
        if (this.level.f_46443_) {
            this.level.m_7785_(this.x, this.y, this.z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.f_46441_.m_188501_() - this.level.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        }
        boolean flag = this.m_254884_();
        if (p_46076_) {
            if (!(this.radius < 2.0f) && flag) {
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            boolean flag1 = this.m_252906_() instanceof Player;
            Util.m_214673_(this.toBlow, (RandomSource)this.level.f_46441_);
            for (BlockPos blockpos : this.toBlow) {
                Level $$9;
                BlockState blockstate = this.level.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (blockstate.m_60795_()) continue;
                BlockPos blockpos1 = blockpos.m_7949_();
                this.level.m_46473_().m_6180_("explosion_blocks");
                if (blockstate.canDropFromExplosion((BlockGetter)this.level, blockpos, (Explosion)this) && ($$9 = this.level) instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)$$9;
                    BlockEntity blockentity = blockstate.m_155947_() ? this.level.m_7702_(blockpos) : null;
                    LootParams.Builder lootparams$builder = new LootParams.Builder(serverlevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockentity).m_287289_(LootContextParams.f_81455_, (Object)this.source);
                    if (this.blockInteraction == Explosion.BlockInteraction.DESTROY_WITH_DECAY) {
                        lootparams$builder.m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(this.radius));
                    }
                    blockstate.m_222967_(serverlevel, blockpos, ItemStack.f_41583_, flag1);
                    blockstate.m_287290_(lootparams$builder).forEach(p_46074_ -> MissileExplosion.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_46074_, blockpos1));
                }
                blockstate.onBlockExploded(this.level, blockpos, (Explosion)this);
                this.level.m_46473_().m_7238_();
            }
            for (Pair pair : objectarraylist) {
                Block.m_49840_((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.fire) {
            for (BlockPos blockpos2 : this.toBlow) {
                if (this.random.m_188503_(3) != 0 || !this.level.m_8055_(blockpos2).m_60795_() || !this.level.m_8055_(blockpos2.m_7495_()).m_60804_((BlockGetter)this.level, blockpos2.m_7495_())) continue;
                this.level.m_46597_(blockpos2, BaseFireBlock.m_49245_((BlockGetter)this.level, (BlockPos)blockpos2));
            }
        }
    }

    public boolean m_254884_() {
        return this.blockInteraction != Explosion.BlockInteraction.KEEP;
    }

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> p_46068_, ItemStack p_46069_, BlockPos p_46070_) {
        int i = p_46068_.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)p_46068_.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)p_46069_)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)p_46069_, (int)16);
            p_46068_.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!p_46069_.m_41619_()) continue;
            return;
        }
        p_46068_.add((Object)Pair.of((Object)p_46069_, (Object)p_46070_));
    }

    public DamageSource m_46077_() {
        return this.damageSource;
    }

    public Map<Player, Vec3> m_46078_() {
        return this.hitPlayers;
    }

    @Nullable
    public LivingEntity m_252906_() {
        Projectile projectile;
        if (this.source == null) {
            return null;
        }
        Entity entity = this.source;
        if (entity instanceof PrimedTnt) {
            PrimedTnt primedtnt = (PrimedTnt)entity;
            return primedtnt.m_19749_();
        }
        entity = this.source;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            return livingentity;
        }
        entity = this.source;
        if (entity instanceof Projectile && (entity = (projectile = (Projectile)entity).m_19749_()) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    @Nullable
    public Entity m_253049_() {
        return this.source;
    }

    public void m_46080_() {
        this.toBlow.clear();
    }

    public List<BlockPos> m_46081_() {
        return this.toBlow;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    @Nullable
    public Entity getExploder() {
        return this.source;
    }

    public static enum BlockInteraction {
        KEEP,
        DESTROY,
        DESTROY_WITH_DECAY;

    }
}

