/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Anti;

import dev.atrox.lightchat.HexColor;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class AntiAdvertising
implements Listener {
    private boolean isEnabled;
    private String warningMessage;
    private final JavaPlugin plugin;
    private FileConfiguration config;
    private List<String> ipPatterns;
    private List<String> domainPatterns;
    private List<String> urlPatterns;

    public AntiAdvertising(JavaPlugin plugin) {
        this.plugin = plugin;
        this.reloadConfiguration();
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.isEnabled) {
            return;
        }
        String message = event.getMessage();
        if (this.containsProhibitedContent(message)) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(HexColor.translateAlternateColorCodes('&', this.warningMessage));
        }
    }

    private boolean containsProhibitedContent(String message) {
        for (String pattern : this.ipPatterns) {
            if (!Pattern.compile(pattern).matcher(message).find()) continue;
            return true;
        }
        for (String pattern : this.domainPatterns) {
            if (!Pattern.compile(pattern).matcher(message).find()) continue;
            return true;
        }
        for (String pattern : this.urlPatterns) {
            if (!Pattern.compile(pattern).matcher(message).find()) continue;
            return true;
        }
        return false;
    }

    public void reloadConfiguration() {
        File configFile = new File(this.plugin.getDataFolder(), "antiadvertising.yml");
        if (!configFile.exists()) {
            this.plugin.saveResource("antiadvertising.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
        FileConfiguration mainConfig = this.plugin.getConfig();
        this.isEnabled = mainConfig.getBoolean("AntiAdvertising.enabled", true);
        this.warningMessage = mainConfig.getString("AntiAdvertising.warning-message", "&bLightChat>> &cAdvertising is not allowed on this server!");
        this.ipPatterns = this.config.getStringList("AntiAdvertising.ip-patterns");
        this.domainPatterns = this.config.getStringList("AntiAdvertising.domain-patterns");
        this.urlPatterns = this.config.getStringList("AntiAdvertising.url-patterns");
    }
}

